/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.scope.test;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;

public class UnmodifiableScopeKeyUnitTestCase
extends AbstractMetaDataTest {
    private static ScopeLevel testLevel1 = new ScopeLevel(1, "ONE");
    private static ScopeLevel testLevel2 = new ScopeLevel(2, "TWO");
    private static ScopeLevel testLevel3 = new ScopeLevel(3, "THREE");
    private static ScopeLevel testLevel4 = new ScopeLevel(4, "FOUR");
    private static ScopeLevel testLevel5 = new ScopeLevel(5, "FIVE");
    private static String testQualifier1 = "qualifier1";
    private static String testQualifier1Different = "qualifier1Different";
    private static String testQualifier2 = "qualifier2";
    private static String testQualifier3 = "qualifier3";
    private static String testQualifier3Different = "qualifier3Different";
    private static String testQualifier4 = "qualifier4";
    private static String testQualifier5 = "qualifier5";
    private static Scope testScope1 = new Scope(testLevel1, (Object)testQualifier1);
    private static Scope testScope1Different = new Scope(testLevel1, (Object)testQualifier1Different);
    private static Scope testScope2 = new Scope(testLevel2, (Object)testQualifier2);
    private static Scope testScope3 = new Scope(testLevel3, (Object)testQualifier3);
    private static Scope testScope3Different = new Scope(testLevel3, (Object)testQualifier3Different);
    private static Scope testScope4 = new Scope(testLevel4, (Object)testQualifier4);
    private static Scope testScope5 = new Scope(testLevel5, (Object)testQualifier5);

    public UnmodifiableScopeKeyUnitTestCase(String name) {
        super(name);
    }

    public void testBasicScopeKeyConstructor() throws Exception {
        ScopeKey key = new ScopeKey();
        Scope[] expected = new Scope[]{};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertNull((Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testSingleScopeKeyConstructor() throws Exception {
        ScopeKey key = new ScopeKey(testScope1);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testLevelQualifierScopeKeyConstructor() throws Exception {
        ScopeKey key = new ScopeKey(testLevel1, (Object)testQualifier1);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testCollectionScopeKeyConstructor() throws Exception {
        Scope[] expected = new Scope[]{};
        HashSet<Scope> set = new HashSet<Scope>();
        ScopeKey key = new ScopeKey(set);
        this.assertScopeKey(expected, key.getOptimizedKey());
        expected = new Scope[]{testScope1};
        set = new HashSet();
        for (Scope scope : expected) {
            set.add(scope);
        }
        key = new ScopeKey(set);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        set = new HashSet();
        for (Scope scope : expected) {
            set.add(scope);
        }
        key = new ScopeKey(set);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testCollectionScopeKeyConstructorSorts() throws Exception {
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        HashSet<Scope> set = new HashSet<Scope>();
        set.add(testScope2);
        set.add(testScope4);
        set.add(testScope5);
        set.add(testScope3);
        set.add(testScope1);
        ScopeKey key = new ScopeKey(set);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testArrayScopeKeyConstructor() throws Exception {
        Scope[] expected = new Scope[]{};
        ScopeKey key = new ScopeKey(expected);
        this.assertScopeKey(expected, key.getOptimizedKey());
        expected = new Scope[]{testScope1};
        key = new ScopeKey(expected);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        key = new ScopeKey(expected);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testArrayScopeKeyConstructorSorts() throws Exception {
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        Scope[] array = new Scope[]{testScope5, testScope3, testScope1, testScope2, testScope4};
        ScopeKey key = new ScopeKey(array);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScope() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testScope1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testScope2, null);
        expected = new Scope[]{testScope1, testScope2};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope2.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeDuplicate() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testScope1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testScope1, testScope1);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeSorts() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testScope1, null);
        this.assertAddScope(key, testScope3, null);
        this.assertAddScope(key, testScope5, null);
        this.assertAddScope(key, testScope2, null);
        this.assertAddScope(key, testScope4, null);
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeChange() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testScope1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testScope1Different, testScope1);
        expected = new Scope[]{testScope1Different};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1Different.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeChangeSorts() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testScope1, null);
        this.assertAddScope(key, testScope2, null);
        this.assertAddScope(key, testScope3, null);
        this.assertAddScope(key, testScope4, null);
        this.assertAddScope(key, testScope5, null);
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testScope3Different, testScope3);
        expected = new Scope[]{testScope1, testScope2, testScope3Different, testScope4, testScope5};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeLevelQualifier() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testLevel1, testQualifier1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testLevel2, testQualifier2, null);
        expected = new Scope[]{testScope1, testScope2};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope2.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeLevelQualifierDuplicate() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testLevel1, testQualifier1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testLevel1, testQualifier1, testScope1);
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeLevelQualifierSorts() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testLevel4, testQualifier4, null);
        this.assertAddScope(key, testLevel2, testQualifier2, null);
        this.assertAddScope(key, testLevel1, testQualifier1, null);
        this.assertAddScope(key, testLevel3, testQualifier3, null);
        this.assertAddScope(key, testLevel5, testQualifier5, null);
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeLevelChange() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testLevel1, testQualifier1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testLevel1, testQualifier1Different, testScope1);
        expected = new Scope[]{testScope1Different};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1Different.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testAddScopeLevelChangeSorts() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testLevel1, testQualifier1, null);
        this.assertAddScope(key, testLevel2, testQualifier2, null);
        this.assertAddScope(key, testLevel3, testQualifier3, null);
        this.assertAddScope(key, testLevel4, testQualifier4, null);
        this.assertAddScope(key, testLevel5, testQualifier5, null);
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3, testScope4, testScope5};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertAddScope(key, testLevel3, testQualifier3Different, testScope3);
        expected = new Scope[]{testScope1, testScope2, testScope3Different, testScope4, testScope5};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testRemoveScope() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testScope1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertRemoveScope(key, testScope1, testScope1);
        expected = new Scope[]{};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertNull((Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testRemoveScopeSorts() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testScope1, null);
        this.assertAddScope(key, testScope2, null);
        this.assertAddScope(key, testScope3, null);
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope3.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertRemoveScope(key, testScope2, testScope2);
        expected = new Scope[]{testScope1, testScope3};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope3.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testRemoveScopeLevel() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testLevel1, testQualifier1, null);
        Scope[] expected = new Scope[]{testScope1};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertRemoveScope(key, testLevel1, testScope1);
        expected = new Scope[]{};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertNull((Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testRemoveScopeLevelSorts() throws Exception {
        ScopeKey key = new ScopeKey();
        this.assertAddScope(key, testLevel1, testQualifier1, null);
        this.assertAddScope(key, testLevel2, testQualifier2, null);
        this.assertAddScope(key, testLevel3, testQualifier3, null);
        Scope[] expected = new Scope[]{testScope1, testScope2, testScope3};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope3.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        this.assertRemoveScope(key, testLevel2, testScope2);
        expected = new Scope[]{testScope1, testScope3};
        this.assertScopeKey(expected, key.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope3.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
    }

    public void testFreeze() throws Exception {
        ScopeKey key = new ScopeKey(testScope1).getOptimizedKey();
        try {
            key.addScope(testScope1);
            UnmodifiableScopeKeyUnitTestCase.fail((String)"Should not be here!");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            key.addScope(testLevel1, (Object)testQualifier1);
            UnmodifiableScopeKeyUnitTestCase.fail((String)"Should not be here!");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            key.removeScope(testScope1);
            UnmodifiableScopeKeyUnitTestCase.fail((String)"Should not be here!");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            key.removeScopeLevel(testLevel1);
            UnmodifiableScopeKeyUnitTestCase.fail((String)"Should not be here!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNoParentEmpty() throws Exception {
        ScopeKey key = new ScopeKey().getOptimizedKey();
        ScopeKey parent = key.getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNull((Object)parent);
    }

    public void testNoParentSingleScope() throws Exception {
        ScopeKey key = new ScopeKey();
        key.addScope(testScope1);
        ScopeKey parent = key.getOptimizedKey().getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNull((Object)parent);
    }

    public void testSimpleParent() throws Exception {
        ScopeKey key = new ScopeKey();
        key.addScope(testScope1);
        key.addScope(testScope2);
        ScopeKey parent = key.getOptimizedKey().getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNotNull((Object)parent);
        ScopeKey expected = new ScopeKey();
        expected.addScope(testScope1);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)parent.getMaxScopeLevel());
    }

    public void testComplexParent() throws Exception {
        ScopeKey key = new ScopeKey();
        key.addScope(testScope1);
        key.addScope(testScope2);
        key.addScope(testScope3);
        key.addScope(testScope4);
        key.addScope(testScope5);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope5.getScopeLevel(), (Object)key.getOptimizedKey().getMaxScopeLevel());
        ScopeKey parent = key.getOptimizedKey().getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNotNull((Object)parent);
        ScopeKey expected = new ScopeKey();
        expected.addScope(testScope1);
        expected.addScope(testScope2);
        expected.addScope(testScope3);
        expected.addScope(testScope4);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected.getOptimizedKey(), (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope4.getScopeLevel(), (Object)parent.getMaxScopeLevel());
        parent = parent.getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNotNull((Object)parent);
        expected = new ScopeKey();
        expected.addScope(testScope1);
        expected.addScope(testScope2);
        expected.addScope(testScope3);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected.getOptimizedKey(), (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope3.getScopeLevel(), (Object)parent.getMaxScopeLevel());
        parent = parent.getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNotNull((Object)parent);
        expected = new ScopeKey();
        expected.addScope(testScope1);
        expected.addScope(testScope2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected.getOptimizedKey(), (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope2.getScopeLevel(), (Object)parent.getMaxScopeLevel());
        parent = parent.getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNotNull((Object)parent);
        expected = new ScopeKey();
        expected.addScope(testScope1);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected.getOptimizedKey(), (Object)parent);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)testScope1.getScopeLevel(), (Object)parent.getMaxScopeLevel());
        parent = parent.getParent();
        UnmodifiableScopeKeyUnitTestCase.assertNull((Object)parent);
    }

    public void testIsParentNoScopes() throws Exception {
        ScopeKey parent = new ScopeKey(testScope1).getOptimizedKey();
        ScopeKey test = new ScopeKey();
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test.getOptimizedKey()));
    }

    public void testIsParentSameScope() throws Exception {
        ScopeKey parent = new ScopeKey(testScope1).getOptimizedKey();
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(parent));
        ScopeKey test = new ScopeKey(testScope1).getOptimizedKey();
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test));
    }

    public void testIsParentDifferentLevel() throws Exception {
        ScopeKey parent = new ScopeKey(testScope1).getOptimizedKey();
        ScopeKey test = new ScopeKey(testScope2).getOptimizedKey();
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test));
    }

    public void testIsParentDifferentQualifier() throws Exception {
        ScopeKey parent = new ScopeKey(testScope1).getOptimizedKey();
        ScopeKey test = new ScopeKey(testScope1Different).getOptimizedKey();
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test));
    }

    public void testIsParent() throws Exception {
        ScopeKey parent = new ScopeKey(testScope1).getOptimizedKey();
        ScopeKey test = new ScopeKey();
        test.addScope(testScope1);
        test.addScope(testScope2);
        UnmodifiableScopeKeyUnitTestCase.assertTrue((boolean)parent.isParent(test));
        UnmodifiableScopeKeyUnitTestCase.assertTrue((boolean)parent.isParent(test.getOptimizedKey()));
        test = new ScopeKey();
        test.addScope(testScope1);
        test.addScope(testScope3);
        UnmodifiableScopeKeyUnitTestCase.assertTrue((boolean)parent.isParent(test));
        UnmodifiableScopeKeyUnitTestCase.assertTrue((boolean)parent.isParent(test.getOptimizedKey()));
    }

    public void testIsParentNotDirectly() throws Exception {
        ScopeKey parent = new ScopeKey(testScope1).getOptimizedKey();
        ScopeKey test = new ScopeKey();
        test.addScope(testScope1);
        test.addScope(testScope2);
        test.addScope(testScope3);
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test.getOptimizedKey()));
    }

    public void testIsParentNotChild() throws Exception {
        ScopeKey parent = new ScopeKey();
        parent.addScope(testScope1);
        parent.addScope(testScope2);
        ScopeKey test = new ScopeKey();
        test.addScope(testScope1);
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.isParent(test.getOptimizedKey()));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.getOptimizedKey().isParent(test.getOptimizedKey()));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)parent.getOptimizedKey().isParent(test));
    }

    public void testIsParentComplicated() throws Exception {
        ScopeKey parent = new ScopeKey();
        parent.addScope(testScope1);
        parent.addScope(testScope2);
        parent.addScope(testScope3);
        parent.addScope(testScope4);
        ScopeKey test = new ScopeKey();
        test.addScope(testScope1);
        test.addScope(testScope2);
        test.addScope(testScope3);
        test.addScope(testScope4);
        test.addScope(testScope5);
        UnmodifiableScopeKeyUnitTestCase.assertTrue((boolean)parent.isParent(test.getOptimizedKey()));
        UnmodifiableScopeKeyUnitTestCase.assertTrue((boolean)parent.getOptimizedKey().isParent(test.getOptimizedKey()));
        UnmodifiableScopeKeyUnitTestCase.assertTrue((boolean)parent.getOptimizedKey().isParent(test));
    }

    public void testEqualsEmpty() throws Exception {
        ScopeKey key1 = new ScopeKey();
        ScopeKey key2 = new ScopeKey();
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1, (Object)key2.getOptimizedKey());
    }

    public void testEqualsAfterAdd() throws Exception {
        ScopeKey key1 = new ScopeKey();
        ScopeKey key2 = new ScopeKey();
        this.assertAddScope(key1, testScope1, null);
        this.assertAddScope(key2, testScope1, null);
        this.assertAddScope(key1, testScope2, null);
        this.assertAddScope(key2, testScope2, null);
        this.assertAddScope(key1, testScope3, null);
        this.assertAddScope(key2, testScope3, null);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1, (Object)key2.getOptimizedKey());
    }

    public void testEqualsAfterRemove() throws Exception {
        ScopeKey key1 = new ScopeKey();
        ScopeKey key2 = new ScopeKey();
        this.assertAddScope(key1, testScope1, null);
        this.assertAddScope(key2, testScope1, null);
        this.assertAddScope(key1, testScope2, null);
        this.assertAddScope(key2, testScope2, null);
        this.assertAddScope(key1, testScope3, null);
        this.assertAddScope(key2, testScope3, null);
        this.assertRemoveScope(key1, testScope2, testScope2);
        this.assertRemoveScope(key2, testScope2, testScope2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1, (Object)key2.getOptimizedKey());
    }

    public void testEqualsAfterReplace() throws Exception {
        ScopeKey key1 = new ScopeKey();
        ScopeKey key2 = new ScopeKey();
        this.assertAddScope(key1, testScope1, null);
        this.assertAddScope(key2, testScope1, null);
        this.assertAddScope(key1, testScope2, null);
        this.assertAddScope(key2, testScope2, null);
        this.assertAddScope(key1, testScope3, null);
        this.assertAddScope(key2, testScope3, null);
        this.assertAddScope(key1, testScope3Different, testScope3);
        this.assertAddScope(key2, testScope3Different, testScope3);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1, (Object)key2.getOptimizedKey());
    }

    public void testNotEqualsAfterAdd() throws Exception {
        ScopeKey key1 = new ScopeKey();
        ScopeKey key2 = new ScopeKey();
        this.assertAddScope(key1, testScope1, null);
        this.assertAddScope(key2, testScope1, null);
        this.assertAddScope(key1, testScope2, null);
        this.assertAddScope(key2, testScope2, null);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1, (Object)key2.getOptimizedKey());
        this.assertAddScope(key1, testScope3, null);
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.getOptimizedKey().equals((Object)key2));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.getOptimizedKey().equals((Object)key2.getOptimizedKey()));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.equals((Object)key2.getOptimizedKey()));
    }

    public void testNotEqualsAfterRemove() throws Exception {
        ScopeKey key1 = new ScopeKey();
        ScopeKey key2 = new ScopeKey();
        this.assertAddScope(key1, testScope1, null);
        this.assertAddScope(key2, testScope1, null);
        this.assertAddScope(key1, testScope2, null);
        this.assertAddScope(key2, testScope2, null);
        this.assertAddScope(key1, testScope3, null);
        this.assertAddScope(key2, testScope3, null);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1, (Object)key2.getOptimizedKey());
        this.assertRemoveScope(key1, testScope2, testScope2);
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.getOptimizedKey().equals((Object)key2));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.getOptimizedKey().equals((Object)key2.getOptimizedKey()));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.equals((Object)key2.getOptimizedKey()));
    }

    public void testNotEqualsAfterReplace() throws Exception {
        ScopeKey key1 = new ScopeKey();
        ScopeKey key2 = new ScopeKey();
        this.assertAddScope(key1, testScope1, null);
        this.assertAddScope(key2, testScope1, null);
        this.assertAddScope(key1, testScope2, null);
        this.assertAddScope(key2, testScope2, null);
        this.assertAddScope(key1, testScope3, null);
        this.assertAddScope(key2, testScope3, null);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1.getOptimizedKey(), (Object)key2.getOptimizedKey());
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)key1, (Object)key2.getOptimizedKey());
        this.assertAddScope(key1, testScope3Different, testScope3);
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.getOptimizedKey().equals((Object)key2));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.getOptimizedKey().equals((Object)key2.getOptimizedKey()));
        UnmodifiableScopeKeyUnitTestCase.assertFalse((boolean)key1.equals((Object)key2.getOptimizedKey()));
    }

    public void testScopeKeyClassMethodsAreCovered() throws Exception {
        ScopeKey scopeKey = new ScopeKey();
        ScopeKey unmodifiableScopeKey = scopeKey.getOptimizedKey();
        Method[] scopeKeyMethods = scopeKey.getClass().getDeclaredMethods();
        Method[] unmodifiableScopeKeyMethods = unmodifiableScopeKey.getClass().getDeclaredMethods();
        for (Method scopeKeyMethod : scopeKeyMethods) {
            int modifiers = scopeKeyMethod.getModifiers();
            if (!Modifier.isPublic(modifiers)) continue;
            boolean matched = false;
            for (Method unmodifiableScopeKeyMethod : unmodifiableScopeKeyMethods) {
                if (!this.match(scopeKeyMethod, unmodifiableScopeKeyMethod)) continue;
                matched = true;
            }
            UnmodifiableScopeKeyUnitTestCase.assertTrue((String)("ScopeKey method " + scopeKeyMethod + " not found in UnmodifiableScopeKey class.  UnmodifiableScopeKey methods=" + this.showMethods(unmodifiableScopeKeyMethods)), (boolean)matched);
        }
    }

    private boolean match(Method m1, Method m2) {
        Object[] m1Types = m1.getParameterTypes();
        Object[] m2Types = m2.getParameterTypes();
        boolean result = m1.getName().equals(m2.getName()) && Arrays.equals(m1Types, m2Types);
        return result;
    }

    private String showMethods(Method[] methods) {
        String result = "";
        for (Method method : methods) {
            result = result + "Method: " + method.toString() + ", ";
        }
        return result;
    }

    protected void assertScopeKey(Scope[] scopes, ScopeKey key) throws Exception {
        UnmodifiableScopeKeyUnitTestCase.assertNotNull((Object)scopes);
        UnmodifiableScopeKeyUnitTestCase.assertNotNull((Object)key);
        Collection result = key.getOptimizedKey().getScopes();
        UnmodifiableScopeKeyUnitTestCase.assertEquals((int)scopes.length, (int)result.size());
        int index = 0;
        for (Scope scope : result) {
            UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)scopes[index++], (Object)scope);
        }
    }

    protected void assertAddScope(ScopeKey key, Scope add, Scope expected) throws Exception {
        Scope previous = key.addScope(add);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)previous);
    }

    protected void assertRemoveScope(ScopeKey key, Scope remove, Scope expected) throws Exception {
        Scope previous = key.removeScope(remove);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)previous);
    }

    protected void assertAddScope(ScopeKey key, ScopeLevel level, String qualifier, Scope expected) throws Exception {
        Scope previous = key.addScope(level, (Object)qualifier);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)previous);
    }

    protected void assertRemoveScope(ScopeKey key, ScopeLevel level, Scope expected) throws Exception {
        Scope previous = key.removeScopeLevel(level);
        UnmodifiableScopeKeyUnitTestCase.assertEquals((Object)expected, (Object)previous);
    }
}

