/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.lang.reflect.Method;
import javassist.CtClass;
import javassist.CtField;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.util.proxy.RuntimeSupport;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistMemberFactory;
import org.jboss.reflect.plugins.javassist.bytecode.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavassistFieldFactory
extends JavassistMemberFactory {
    protected static final String[] interfaceNames = new String[]{JavassistField.class.getName()};
    protected static final Method[] methods = new Method[2];
    final CtField ctField;
    final String className = JavassistField.class.getName() + counter.incrementAndGet();

    JavassistFieldFactory(Class<?> superClass, CtField ctField, boolean debug) {
        super(superClass, debug);
        this.ctField = ctField;
    }

    @Override
    String getGeneratedClassName() {
        return this.className;
    }

    @Override
    String[] getInterfaceNames() {
        return interfaceNames;
    }

    private CtClass getFieldType() {
        try {
            return this.ctField.getType();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    String getAccessedMember() {
        return this.ctField.getDeclaringClass().getName() + "." + this.ctField.getName() + this.ctField.getSignature();
    }

    @Override
    String initAccessedMember() {
        return null;
    }

    @Override
    MethodInfo implementMethod(int index, ConstPool cp) {
        if (index >= methods.length) {
            return null;
        }
        String desc = RuntimeSupport.makeDescriptor((Method)methods[index]);
        MethodInfo minfo = new MethodInfo(cp, methods[index].getName(), desc);
        minfo.setAccessFlags(1);
        this.setThrows(minfo, cp, methods[index].getExceptionTypes());
        Bytecode code = new Bytecode(cp, 0, 0);
        int pc = code.currentPc();
        boolean isStatic = Modifier.isStatic((int)this.ctField.getModifiers());
        int maxLocals = 0;
        if (index == 0) {
            maxLocals = 2;
            this.makeGetMethod(code, methods[index], cp, isStatic);
        } else {
            maxLocals = 3;
            this.makeSetMethod(code, methods[index], cp, isStatic);
        }
        code.setMaxLocals(maxLocals);
        CodeAttribute ca = code.toCodeAttribute();
        minfo.setCodeAttribute(ca);
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        writer.sameFrame(pc);
        ca.setAttribute(writer.toStackMapTable(cp));
        return minfo;
    }

    private void makeGetMethod(Bytecode code, Method method, ConstPool cp, boolean isStatic) {
        if (isStatic) {
            code.addGetstatic(this.ctField.getDeclaringClass().getName(), this.ctField.getName(), this.ctField.getSignature());
        } else {
            code.addAload(1);
            code.addCheckcast(this.ctField.getDeclaringClass());
            code.addGetfield(this.ctField.getDeclaringClass(), this.ctField.getName(), this.ctField.getSignature());
        }
        this.boxReturnValue(code, this.getFieldType());
        code.addOpcode(176);
    }

    private void makeSetMethod(Bytecode code, Method method, ConstPool cp, boolean isStatic) {
        if (!isStatic) {
            code.addAload(1);
            code.addCheckcast(this.ctField.getDeclaringClass());
        }
        code.addAload(2);
        this.castAndUnbox(code, this.getFieldType());
        if (isStatic) {
            code.addPutstatic(this.ctField.getDeclaringClass().getName(), this.ctField.getName(), this.ctField.getSignature());
        } else {
            code.addPutfield(this.ctField.getDeclaringClass(), this.ctField.getName(), this.ctField.getSignature());
        }
        code.addOpcode(177);
    }

    static {
        try {
            JavassistFieldFactory.methods[0] = SecurityActions.getDeclaredMethod(JavassistField.class, "get", Object.class);
            JavassistFieldFactory.methods[1] = SecurityActions.getDeclaredMethod(JavassistField.class, "set", Object.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

