/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.lang.reflect.Modifier;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.bytecode.BytecodeAccessController;
import org.jboss.reflect.plugins.bytecode.BytecodeAnnotatedInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeVariableSpy;
import org.jboss.reflect.plugins.bytecode.SignatureKey;
import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.MemberAccessorFactory;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class BytecodeFieldInfo
extends BytecodeAnnotatedInfo
implements FieldInfo {
    private static final long serialVersionUID = -104555531831318930L;
    private final FieldBytes fieldBytes;
    private volatile transient FieldAccessor field;
    private volatile transient TypeInfo fieldType;
    protected final BytecodeTypeInfo typeInfo;
    private volatile transient String name;
    private volatile transient boolean initializedModifiers;
    private volatile transient int modifiers;

    public BytecodeFieldInfo(AnnotationHelper annotationHelper, BytecodeTypeInfo typeInfo, FieldBytes fieldBytes) {
        super(annotationHelper);
        this.typeInfo = typeInfo;
        this.fieldBytes = fieldBytes;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.fieldBytes.getName();
        }
        return this.name;
    }

    public int getModifiers() {
        if (!this.initializedModifiers) {
            this.modifiers = this.fieldBytes.getModifiers();
            this.initializedModifiers = true;
        }
        return this.modifiers;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    public BytecodeTypeInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public TypeInfo getType() {
        if (this.fieldType != null) {
            return this.fieldType;
        }
        String signature = this.fieldBytes.getGenericSignature();
        if (signature != null) {
            SignatureAttribute.ObjectType type;
            try {
                type = SignatureAttribute.toFieldSignature((String)signature);
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
            SignatureAttribute.ClassSignature sig = this.getDeclaringClass().getClassSignature();
            this.fieldType = this.typeInfo.getFactory().getTypeInfo(this.typeInfo.getClassLoaderInternal(), (SignatureAttribute.Type)type, BytecodeTypeVariableSpy.createForField(sig));
        } else {
            try {
                this.fieldType = this.typeInfo.getFactory().getTypeInfo(SignatureKey.getFieldType(this.fieldBytes), this.getDeclaringClass().getClassLoaderInternal());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.fieldType;
    }

    public Object get(Object target) throws Throwable {
        BytecodeAccessController.checkAccess(this);
        return this.getJavassistField().get(target);
    }

    public Object set(Object target, Object value) throws Throwable {
        BytecodeAccessController.checkAccess(this);
        this.getJavassistField().set(target, value);
        return null;
    }

    private FieldAccessor getJavassistField() throws Throwable {
        if (this.field == null) {
            FieldAccessor f = MemberAccessorFactory.INSTANCE.createField(this);
            if (this.field == null) {
                this.field = f;
            }
        }
        return this.field;
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FieldInfo)) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.getDeclaringClass().equals(other.getDeclaringClass());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.fieldBytes);
    }

    public String getDescriptor() {
        return this.fieldBytes.getJvmSignature();
    }
}

