/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.accessor.metrics;

import org.jboss.reflect.plugins.bytecode.accessor.ConstructorAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.MethodAccessor;

/**
 * Factory to wrap the accessor classes in an implementation that records the metrics
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class MetricsAccessorFactory
{
   
   public static MethodAccessor createMethodAccessor(MethodAccessor accessor, String sig)
   {
      return new MetricsMethodAccessor(accessor, sig);
   }
   
   public static ConstructorAccessor createConstructorAccessor(ConstructorAccessor accessor, String sig)
   {
      return new MetricsConstructorAccessor(accessor, sig);
   }
   
   public static FieldAccessor createFieldAccessor(FieldAccessor accessor, String sig)
   {
      return new MetricsFieldAccessor(accessor, sig);
   }
}
