/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.xml.bind.DatatypeConverter;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.ClientUtil;
import org.jboss.naming.remote.client.RemoteContextFactory;
import org.jboss.naming.remote.client.SecurityActions;
import org.jboss.naming.remote.protocol.IoFutureHelper;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    private static final Logger logger = Logger.getLogger(InitialContextFactory.class);
    private static final String CLIENT_PROPS_FILE_NAME = "jboss-naming-client.properties";
    private static final long DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 5000L;
    private static final String CLIENT_PROP_KEY_ENDPOINT_NAME = "jboss.naming.client.endpoint.name";
    private static final String CLIENT_PROP_KEY_CONNECT_TIMEOUT = "jboss.naming.client.connect.timeout";
    private static final String ENDPOINT_CREATION_OPTIONS_PREFIX = "jboss.naming.client.endpoint.create.options.";
    private static final String CONNECT_OPTIONS_PREFIX = "jboss.naming.client.connect.options.";
    private static final String REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX = "jboss.naming.client.remote.connectionprovider.create.options.";
    private static final String CALLBACK_HANDLER_KEY = "jboss.naming.client.security.callback.handler.class";
    private static final String PASSWORD_BASE64_KEY = "jboss.naming.client.security.password.base64";
    private static final String REALM_KEY = "jboss.naming.client.security.realm";
    private static final OptionMap DEFAULT_ENDPOINT_CREATION_OPTIONS = OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true);
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final OptionMap DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS = OptionMap.EMPTY;

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        Properties clientProperties = this.findAndCreateClientProperties(env);
        try {
            Connection connection = this.createConnection(clientProperties);
            IoFuture futureChannel = connection.openChannel("naming", OptionMap.EMPTY);
            Channel channel = (Channel)IoFutureHelper.get(futureChannel, 5000L, TimeUnit.MILLISECONDS);
            return RemoteContextFactory.createVersionedContext(channel, env);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw ClientUtil.namingException("Failed to create remoting connection", t);
        }
    }

    private Endpoint createEndpoint(Properties clientProperties) throws IOException {
        String clientEndpointName = clientProperties.getProperty(CLIENT_PROP_KEY_ENDPOINT_NAME);
        if (clientEndpointName == null) {
            clientEndpointName = "config-based-naming-client-endpoint";
        }
        OptionMap endPointCreationOptionsFromConfiguration = this.getOptionMapFromProperties(clientProperties, ENDPOINT_CREATION_OPTIONS_PREFIX);
        OptionMap endPointCreationOptions = this.mergeWithDefaults(DEFAULT_ENDPOINT_CREATION_OPTIONS, endPointCreationOptionsFromConfiguration);
        Endpoint clientEndpoint = Remoting.createEndpoint((String)clientEndpointName, (OptionMap)endPointCreationOptions);
        OptionMap remoteConnectionProivderOptionsFromConfiguration = this.getOptionMapFromProperties(clientProperties, REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX);
        OptionMap remoteConnectionProivderOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS, remoteConnectionProivderOptionsFromConfiguration);
        clientEndpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), remoteConnectionProivderOptions);
        return clientEndpoint;
    }

    private Connection createConnection(Properties clientProperties) throws IOException, URISyntaxException, NamingException {
        String connectionUrl = clientProperties.getProperty("java.naming.provider.url");
        if (connectionUrl == null || connectionUrl.trim().isEmpty()) {
            throw new NamingException("No provider URL configured for connection");
        }
        OptionMap connectOptionsFromConfiguration = this.getOptionMapFromProperties(clientProperties, CONNECT_OPTIONS_PREFIX);
        OptionMap connectOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_CREATION_OPTIONS, connectOptionsFromConfiguration);
        Endpoint clientEndpoint = this.createEndpoint(clientProperties);
        long connectionTimeout = 5000L;
        String connectionTimeoutValue = clientProperties.getProperty(CLIENT_PROP_KEY_CONNECT_TIMEOUT);
        if (connectionTimeoutValue != null && !connectionTimeoutValue.trim().isEmpty()) {
            try {
                connectionTimeout = Long.parseLong(connectionTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                logger.info((Object)("Incorrect timeout value " + connectionTimeoutValue + " specified. Falling back to default connection timeout value " + 5000L + " milli secondss"));
            }
        }
        CallbackHandler callbackHandler = this.createCallbackHandler(clientProperties);
        URI connectionURI = new URI(connectionUrl);
        IoFuture futureConnection = clientEndpoint.connect(connectionURI, connectOptions, callbackHandler);
        return (Connection)IoFutureHelper.get(futureConnection, connectionTimeout, TimeUnit.MILLISECONDS);
    }

    private CallbackHandler createCallbackHandler(Properties clientProperties) throws NamingException {
        String realm;
        String passwordBase64;
        String password;
        String userName;
        String callbackClass = clientProperties.getProperty(CALLBACK_HANDLER_KEY);
        CallbackHandler handler = this.resolveCallbackHandler(callbackClass, userName = clientProperties.getProperty("java.naming.security.principal"), password = clientProperties.getProperty("java.naming.security.credentials"), passwordBase64 = clientProperties.getProperty(PASSWORD_BASE64_KEY), realm = clientProperties.getProperty(REALM_KEY));
        if (handler != null) {
            return handler;
        }
        return new AnonymousCallbackHandler();
    }

    private CallbackHandler resolveCallbackHandler(String callbackClass, String userName, String password, String passwordBase64, String realm) throws NamingException {
        if (callbackClass != null && (userName != null || password != null)) {
            throw new RuntimeException("Cannot specify both a callback handler and a username/password for connection.");
        }
        if (callbackClass != null) {
            ClassLoader classLoader = InitialContextFactory.getClientClassLoader();
            try {
                Class<?> clazz = Class.forName(callbackClass, true, classLoader);
                return (CallbackHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load callback handler class " + callbackClass, e);
            }
            catch (Exception e) {
                throw ClientUtil.namingException("Could not instantiate handler instance of type " + callbackClass, e);
            }
        }
        if (userName != null) {
            String decodedPassword;
            if (password != null && passwordBase64 != null) {
                throw new NamingException("Cannot specify both a plain text and base64 encoded password");
            }
            if (passwordBase64 != null) {
                try {
                    decodedPassword = DatatypeConverter.printBase64Binary((byte[])passwordBase64.getBytes());
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Could not decode base64 encoded password for connection", e);
                }
            } else {
                decodedPassword = password != null ? password : null;
            }
            return new AuthenticationCallbackHandler(userName, decodedPassword.toCharArray(), realm);
        }
        return null;
    }

    private OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix) {
        ClassLoader classLoader = InitialContextFactory.getClientClassLoader();
        OptionMap.Builder optionMapBuilder = OptionMap.builder().parseAll(properties, propertyPrefix, classLoader);
        OptionMap optionMap = optionMapBuilder.getMap();
        logger.debug((Object)(propertyPrefix + " has the following options " + optionMap));
        return optionMap;
    }

    private OptionMap mergeWithDefaults(OptionMap defaults, OptionMap overrides) {
        OptionMap.Builder combinedOptionsBuilder = OptionMap.builder().addAll(overrides);
        for (Option defaultOption : defaults) {
            if (combinedOptionsBuilder.getMap().contains(defaultOption)) continue;
            Object defaultValue = defaults.get(defaultOption);
            combinedOptionsBuilder.set(defaultOption, defaultValue);
        }
        OptionMap combinedOptions = combinedOptionsBuilder.getMap();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Options " + overrides + " have been merged with defaults " + defaults + " to form " + combinedOptions));
        }
        return combinedOptions;
    }

    private static ClassLoader getClientClassLoader() {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return InitialContextFactory.class.getClassLoader();
    }

    private Properties findAndCreateClientProperties(Hashtable<?, ?> env) {
        Properties props = this.findClientProperties();
        if (props == null) {
            props = new Properties();
        }
        for (Map.Entry<?, ?> entry : env.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    private Properties findClientProperties() {
        ClassLoader classLoader = InitialContextFactory.getClientClassLoader();
        logger.debug((Object)("Looking for jboss-naming-client.properties using classloader " + classLoader));
        InputStream clientPropsInputStream = classLoader.getResourceAsStream(CLIENT_PROPS_FILE_NAME);
        if (clientPropsInputStream != null) {
            logger.debug((Object)("Found jboss-naming-client.properties using classloader " + classLoader));
            Properties clientProps = new Properties();
            try {
                clientProps.load(clientPropsInputStream);
                return clientProps;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load jboss-naming-client.properties", e);
            }
        }
        return null;
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private final String realm;
        private final String username;
        private final char[] password;

        private AuthenticationCallbackHandler(String username, char[] password, String realm) {
            this.username = username;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    if (this.realm == null) {
                        String defaultText = rcb.getDefaultText();
                        rcb.setText(defaultText);
                        continue;
                    }
                    rcb.setText(this.realm);
                    continue;
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }
}

