/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.naming.remote.client.ClientUtil;
import org.jboss.naming.remote.client.RemoteNamingStore;

public class RemoteContext
implements Context,
NameParser {
    private final Name prefix;
    private final Hashtable<String, Object> environment;
    final RemoteNamingStore namingStore;

    public RemoteContext(RemoteNamingStore namingStore, Hashtable<String, Object> environment) {
        this(new CompositeName(), namingStore, environment);
    }

    public RemoteContext(Name prefix, RemoteNamingStore namingStore, Hashtable<String, Object> environment) {
        this.prefix = prefix;
        this.namingStore = namingStore;
        this.environment = environment;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (ClientUtil.isEmpty(name)) {
            return new RemoteContext(this.prefix, this.namingStore, this.environment);
        }
        return this.namingStore.lookup(this.getAbsoluteName(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.parse(name));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.namingStore.bind(this.getAbsoluteName(name), object);
    }

    @Override
    public void bind(String name, Object object) throws NamingException {
        this.bind(this.parse(name), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.namingStore.rebind(name, object);
    }

    @Override
    public void rebind(String name, Object object) throws NamingException {
        this.rebind(this.parse(name), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.namingStore.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.parse(name));
    }

    @Override
    public void rename(Name name, Name newName) throws NamingException {
        this.namingStore.rename(name, newName);
    }

    @Override
    public void rename(String name, String newName) throws NamingException {
        this.rename(this.parse(name), this.parse(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return ClientUtil.namingEnumeration(this.namingStore.list(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return ClientUtil.namingEnumeration(this.namingStore.listBindings(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.namingStore.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.namingStore.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.namingStore.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this;
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return this;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this.parse(name), this.parse(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        return this.environment.put(s, o);
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        return this.environment.remove(s);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        this.namingStore.close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    @Override
    public Name parse(String name) throws NamingException {
        return new CompositeName(name);
    }

    private Name getAbsoluteName(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.composeName(name, this.prefix);
        }
        return this.composeName(name, this.prefix);
    }
}

