/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.virtual.plugins.context.HierarchyVirtualFileHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.plugins.context.jar.JarEntryHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.jar.NestedJarHandler;
import org.jboss.virtual.plugins.context.jar.NoCopyNestedJarHandler;
import org.jboss.virtual.plugins.context.jar.SynthenticDirEntryHandler;
import org.jboss.virtual.plugins.context.jar.ZipEntryWrapper;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructuredJarHandler<T>
extends AbstractJarHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private transient List<VirtualFileHandler> entries;
    private transient Map<String, VirtualFileHandler> entryMap;
    private static boolean forceNoCopy = AccessController.doPrivileged(new CheckForceNoCopy());

    protected AbstractStructuredJarHandler(VFSContext context, VirtualFileHandler parent, URL url, JarFile jar, ZipEntry entry, String name) throws IOException {
        super(context, parent, url, jar, entry, name);
    }

    protected void initJarFile() throws IOException {
        JarEntryEnumeration enumeration = new JarEntryEnumeration(this.getJar().entries());
        this.initJarFile(enumeration);
    }

    protected void initJarFile(Enumeration<ZipEntryWrapper<T>> enumeration) throws IOException {
        if (!enumeration.hasMoreElements()) {
            this.entries = Collections.emptyList();
            this.entryMap = Collections.emptyMap();
            return;
        }
        HashMap<String, VirtualFileHandler> parentMap = new HashMap<String, VirtualFileHandler>();
        ArrayList levelMapList = new ArrayList();
        this.entries = new ArrayList<VirtualFileHandler>();
        this.entryMap = new HashMap<String, VirtualFileHandler>();
        boolean trace = log.isTraceEnabled();
        while (enumeration.hasMoreElements()) {
            ZipEntryWrapper<T> wrapper = enumeration.nextElement();
            this.extraWrapperInfo(wrapper);
            String[] paths = wrapper.getName().split("/");
            int n = paths.length;
            if (n >= levelMapList.size()) {
                for (int n2 = levelMapList.size(); n2 <= n; ++n2) {
                    levelMapList.add(new ArrayList());
                }
            }
            ArrayList levelMap = (ArrayList)levelMapList.get(n);
            levelMap.add(wrapper);
            if (!trace) continue;
            log.trace((Object)("added " + wrapper.getName() + " at depth " + n));
        }
        int level = 0;
        for (ArrayList arrayList : levelMapList) {
            if (trace) {
                log.trace((Object)("Level(" + level++ + "): " + arrayList));
            }
            for (ZipEntryWrapper wrapper : arrayList) {
                String parentName;
                String name = wrapper.getName();
                int slash = wrapper.isDirectory() ? name.lastIndexOf(47, name.length() - 2) : name.lastIndexOf(47, name.length() - 1);
                VirtualFileHandler parent = this;
                if (slash >= 0 && (parent = (VirtualFileHandler)parentMap.get(parentName = name.substring(0, slash + 1))) == null) {
                    parent = this.buildParents(parentName, parentMap, wrapper);
                }
                int start = slash + 1;
                int end = wrapper.isDirectory() ? name.length() - 1 : name.length();
                String entryName = name.substring(start, end);
                VirtualFileHandler handler = this.createVirtualFileHandler(parent, wrapper, entryName);
                if (wrapper.isDirectory()) {
                    parentMap.put(name, handler);
                    if (trace) {
                        log.trace((Object)("Added parent: " + name));
                    }
                }
                if (parent == this) {
                    this.entries.add(handler);
                    this.entryMap.put(entryName, handler);
                    continue;
                }
                if (!(parent instanceof HierarchyVirtualFileHandler)) continue;
                HierarchyVirtualFileHandler ehandler = (HierarchyVirtualFileHandler)((Object)parent);
                ehandler.addChild(handler);
            }
        }
    }

    protected void extraWrapperInfo(ZipEntryWrapper<T> wrapper) throws IOException {
    }

    protected VirtualFileHandler buildParents(String parentName, Map<String, VirtualFileHandler> parentMap, ZipEntryWrapper<T> wrapper) throws IOException {
        VirtualFileHandler parent = this;
        String[] paths = PathTokenizer.getTokens(parentName);
        StringBuilder pathName = new StringBuilder();
        for (String path : paths) {
            pathName.append(path);
            pathName.append('/');
            VirtualFileHandler next = parent.getChild(path);
            if (next == null) {
                next = this.createSynthenticParent(parent, path, wrapper);
            }
            parentMap.put(pathName.toString(), next);
            parent = next;
        }
        return parent;
    }

    protected VirtualFileHandler createSynthenticParent(VirtualFileHandler parent, String path, ZipEntryWrapper<T> wrapper) throws IOException {
        URL url = this.getURL(parent, path, true);
        SynthenticDirEntryHandler next = new SynthenticDirEntryHandler(this.getVFSContext(), parent, path, wrapper.getTime(), url);
        if (parent == this) {
            this.entries.add(next);
            this.entryMap.put(path, next);
        } else if (parent instanceof HierarchyVirtualFileHandler) {
            HierarchyVirtualFileHandler ehandler = (HierarchyVirtualFileHandler)((Object)parent);
            ehandler.addChild(next);
        }
        return next;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.entries);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        return this.entryMap.get(name);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    protected VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, ZipEntryWrapper<T> wrapper, String entryName) throws IOException {
        String flag;
        boolean useNoCopyJarHandler;
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("Null entry wrapper");
        }
        ZipEntry entry = wrapper.getEntry();
        URL url = this.getURL(parent, entryName, entry.isDirectory());
        VFSContext context = parent.getVFSContext();
        AbstractJarHandler vfh = JarUtils.isArchive(entry.getName()) ? ((useNoCopyJarHandler = Boolean.valueOf(flag = context.getOptions().get("useNoCopyJarHandler")).booleanValue()) || forceNoCopy ? new NoCopyNestedJarHandler(context, parent, this.getJar(), entry, url, entryName) : NestedJarHandler.create(context, parent, this.getJar(), entry, url, entryName)) : new JarEntryHandler(context, parent, this.getJar(), entry, entryName, url);
        return vfh;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initJarFile();
    }

    static {
        if (forceNoCopy) {
            log.info((Object)"VFS force NoCopyNestedJarHandler is enabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckForceNoCopy
    implements PrivilegedAction<Boolean> {
        private CheckForceNoCopy() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceNoCopy", "false");
            return Boolean.valueOf(forceString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JarEntryEnumeration
    implements Enumeration<ZipEntryWrapper<T>> {
        private Enumeration<JarEntry> enumeration;

        public JarEntryEnumeration(Enumeration<JarEntry> enumeration) {
            if (enumeration == null) {
                throw new IllegalArgumentException("Null enumeration");
            }
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public ZipEntryWrapper<T> nextElement() {
            JarEntry entry = this.enumeration.nextElement();
            return new ZipEntryWrapper(entry);
        }
    }
}

