/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.virtual.plugins.context.HierarchyVirtualFileHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarEntryHandler
extends AbstractJarHandler
implements StructuredVirtualFileHandler,
HierarchyVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private List<VirtualFileHandler> entryChildren;
    private transient Map<String, VirtualFileHandler> entryMap;

    public JarEntryHandler(VFSContext context, VirtualFileHandler parent, JarFile jar, ZipEntry entry, String entryName, URL url) throws IOException {
        super(context, parent, url, jar, entry, entryName);
        try {
            this.setVfsUrl(this.getChildVfsUrl(entryName, entry.isDirectory()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void initCacheLastModified() {
    }

    @Override
    public boolean hasBeenModified() throws IOException {
        return false;
    }

    @Override
    public void addChild(VirtualFileHandler child) {
        if (this.entryChildren == null) {
            this.entryChildren = new ArrayList<VirtualFileHandler>();
        }
        this.entryChildren.add(child);
        if (this.entryMap != null) {
            this.entryMap.put(child.getName(), child);
        }
    }

    @Override
    public long getLastModified() {
        return this.getEntry().getTime();
    }

    @Override
    public long getSize() {
        return this.getEntry().getSize();
    }

    @Override
    public boolean isLeaf() {
        return !this.getEntry().isDirectory();
    }

    @Override
    public boolean isHidden() {
        this.checkClosed();
        return false;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        if (this.entryChildren == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.entryChildren);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.getJar().getInputStream(this.getEntry());
    }

    @Override
    public synchronized VirtualFileHandler createChildHandler(String name) throws IOException {
        if (this.entryChildren == null) {
            return null;
        }
        if (this.entryMap == null) {
            this.entryMap = new HashMap<String, VirtualFileHandler>();
            for (VirtualFileHandler child : this.entryChildren) {
                this.entryMap.put(child.getName(), child);
            }
        }
        return this.entryMap.get(name);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        this.entryChildren.remove(original);
        this.entryChildren.add(replacement);
        this.entryMap.put(original.getName(), replacement);
    }
}

