/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.virtual.plugins.context.jar.AbstractStructuredJarHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedJarHandler
extends AbstractStructuredJarHandler<Object> {
    private static final long serialVersionUID = 1L;
    private transient File temp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFile createTempJar(File temp, JarFile parentJar, ZipEntry entry) throws IOException {
        InputStream inputStream = parentJar.getInputStream(entry);
        try {
            FileOutputStream outputStream = new FileOutputStream(temp);
            try {
                byte[] buffer = new byte[8096];
                int read = inputStream.read(buffer);
                while (read != -1) {
                    outputStream.write(buffer, 0, read);
                    read = inputStream.read(buffer);
                }
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignored) {}
        }
        return new JarFile(temp);
    }

    public static NestedJarHandler create(VFSContext context, VirtualFileHandler parent, JarFile parentJar, ZipEntry entry, URL url, String entryName) throws IOException {
        File temp;
        try {
            temp = File.createTempFile("nestedjar", null);
            temp.deleteOnExit();
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
        return new NestedJarHandler(context, parent, parentJar, entry, url, temp, entryName);
    }

    protected NestedJarHandler(VFSContext context, VirtualFileHandler parent, JarFile parentJar, ZipEntry entry, URL original, File temp, String entryName) throws IOException {
        super(context, parent, temp.toURL(), NestedJarHandler.createTempJar(temp, parentJar, entry), entry, entryName);
        try {
            this.setPathName(this.getChildPathName(entryName, false));
            this.setVfsUrl(this.getChildVfsUrl(entryName, false));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.temp = temp;
        try {
            this.initJarFile();
        }
        catch (IOException old) {
            IOException e = new IOException("Error opening jar file: " + original + " reason=" + old.getMessage());
            e.setStackTrace(old.getStackTrace());
            throw e;
        }
    }

    @Override
    public long getLastModified() throws IOException {
        return this.getEntry().getTime();
    }

    @Override
    public long getSize() throws IOException {
        return this.getEntry().getSize();
    }

    @Override
    public InputStream openStream() throws IOException {
        return new FileInputStream(this.temp);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

