/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class VirtualFileURLConnection
extends URLConnection {
    public static Map<URL, VFS> urlCache = Collections.synchronizedMap(new HashMap());
    protected VirtualFile file;
    protected URL vfsurl;
    protected String relativePath;

    public VirtualFileURLConnection(URL url, URL vfsurl, String relativePath) {
        super(url);
        this.vfsurl = vfsurl;
        this.relativePath = relativePath;
    }

    public VirtualFileURLConnection(URL url, VirtualFile file) {
        super(url);
        this.file = file;
    }

    public void connect() throws IOException {
    }

    public Object getContent() throws IOException {
        return this.getVirtualFile();
    }

    public static VirtualFile resolveCachedVirtualFile(URL vfsurl, String relativePath) throws IOException {
        VFS vfs = urlCache.get(vfsurl);
        if (vfs == null) {
            vfs = VFS.getVFS(vfsurl);
            urlCache.put(vfsurl, vfs);
        } else if (vfs.getRoot().hasBeenModified()) {
            vfs = VFS.getVFS(vfsurl);
            urlCache.put(vfsurl, vfs);
        }
        return vfs.findChild(relativePath);
    }

    public static VirtualFile resolveVirtualFile(URL vfsurl, String relativePath) throws IOException {
        VFS vfs = VFS.getVFS(vfsurl);
        return vfs.findChild(relativePath);
    }

    public synchronized VirtualFile getVirtualFile() throws IOException {
        if (this.file == null) {
            this.file = this.getUseCaches() ? VirtualFileURLConnection.resolveCachedVirtualFile(this.vfsurl, this.relativePath) : VirtualFileURLConnection.resolveVirtualFile(this.vfsurl, this.relativePath);
        }
        return this.file;
    }

    public InputStream getInputStream() throws IOException {
        return this.getVirtualFile().openStream();
    }
}

