/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.virtual.plugins.context.zip.SizeLimitedInputStream;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.plugins.context.zip.ZipWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipStreamWrapper
extends ZipWrapper {
    private byte[] zipBytes;
    private String name;

    ZipStreamWrapper(InputStream zipStream, String name, long lastModified) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipEntryContext.copyStreamAndClose(zipStream, bout);
        this.zipBytes = bout.toByteArray();
        this.name = name;
        this.lastModified = lastModified;
    }

    @Override
    boolean exists() {
        return true;
    }

    @Override
    long getLastModified() {
        return this.lastModified;
    }

    @Override
    String getName() {
        return this.name;
    }

    @Override
    long getSize() {
        return this.zipBytes.length;
    }

    @Override
    InputStream openStream(ZipEntry ent) throws IOException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.zipBytes));
        ZipEntry entry = zis.getNextEntry();
        while (entry != null && !entry.getName().equals(ent.getName())) {
            entry = zis.getNextEntry();
        }
        if (entry == null) {
            throw new IOException("Failed to find nested jar entry: " + ent.getName() + " in zip stream: " + this.name);
        }
        return new SizeLimitedInputStream(zis, (int)entry.getSize());
    }

    @Override
    InputStream getRootAsStream() throws FileNotFoundException {
        return new ByteArrayInputStream(this.zipBytes);
    }

    @Override
    void acquire() throws IOException {
    }

    @Override
    Enumeration<? extends ZipEntry> entries() throws IOException {
        return new ZipStreamEnumeration(new ZipInputStream(new ByteArrayInputStream(this.zipBytes)));
    }

    @Override
    void close() {
        this.zipBytes = null;
    }

    public String toString() {
        return super.toString() + " - " + this.name;
    }

    class ZipStreamEnumeration
    implements Enumeration {
        private ZipInputStream zis;
        private ZipEntry entry;

        ZipStreamEnumeration(ZipInputStream zis) throws IOException {
            this.zis = zis;
            this.entry = zis.getNextEntry();
        }

        public boolean hasMoreElements() {
            return this.entry != null;
        }

        public Object nextElement() {
            ZipEntry ret = this.entry;
            try {
                this.entry = this.zis.getNextEntry();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to retrieve next entry from zip stream", ex);
            }
            return ret;
        }
    }
}

