/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import org.jboss.util.CachePolicy;
import org.jboss.virtual.plugins.cache.PathMatchingVFSCache;
import org.jboss.virtual.spi.VFSContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachePolicyVFSCache
extends PathMatchingVFSCache {
    private CachePolicy policy;

    @Override
    public Iterable<VFSContext> getCachedContexts() {
        return Collections.emptySet();
    }

    @Override
    public int size() {
        return this.policy != null ? this.policy.size() : -1;
    }

    @Override
    protected void check() {
        if (this.policy == null) {
            throw new IllegalArgumentException("Cache needs to be started first.");
        }
    }

    @Override
    public void start() throws Exception {
        this.policy = this.createCachePolicy();
        if (this.policy == null) {
            throw new IllegalArgumentException("Policy is null.");
        }
        this.policy.create();
        try {
            this.policy.start();
        }
        catch (Exception e) {
            try {
                this.policy.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.policy != null) {
            try {
                this.policy.stop();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                this.policy.destroy();
            }
            catch (Exception exception) {
            }
            finally {
                this.policy = null;
            }
        }
    }

    @Override
    public void flush() {
        if (this.policy != null) {
            this.policy.flush();
        }
    }

    @Override
    protected VFSContext getContext(String path) {
        return (VFSContext)VFSContext.class.cast(this.policy.get((Object)path));
    }

    @Override
    protected void putContext(String path, VFSContext context) {
        Object result = this.policy.peek((Object)path);
        if (result == null) {
            this.policy.insert((Object)path, (Object)context);
        }
    }

    @Override
    public void removeContext(String key, VFSContext context) {
        this.policy.remove((Object)key);
    }

    protected abstract CachePolicy createCachePolicy();

    protected static String readSystemProperty(final String key, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(key, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    protected static Integer parseInteger(String value) {
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }
}

