/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreInitializeVFSContexts {
    private Logger log = Logger.getLogger(PreInitializeVFSContexts.class);
    private List<URL> initializedVFSContexts;
    private boolean holdReference;
    private List<VFS> references;

    public void start() throws Exception {
        if (this.initializedVFSContexts != null && !this.initializedVFSContexts.isEmpty()) {
            if (this.holdReference) {
                this.references = new ArrayList<VFS>();
            }
            for (URL url : this.initializedVFSContexts) {
                VFS vfs = VFS.getVFS(url);
                this.log.debug((Object)("Initialized Virtual File: " + vfs.getRoot()));
                if (!this.holdReference) continue;
                this.references.add(vfs);
            }
        }
    }

    public void stop() {
        if (this.references != null) {
            this.references.clear();
        }
    }

    public List<VFS> getReferences() {
        return this.references;
    }

    public void setInitializedVFSContexts(List<URL> initializedVFSContexts) {
        this.initializedVFSContexts = initializedVFSContexts;
    }

    public void setHoldReference(boolean holdReference) {
        this.holdReference = holdReference;
    }
}

