/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;
import org.jboss.virtual.plugins.cache.CachePolicyVFSCache;

public class TimedVFSCache
extends CachePolicyVFSCache {
    private Integer defaultLifetime;
    private Boolean threadSafe;
    private Integer resolution;

    public TimedVFSCache() {
    }

    public TimedVFSCache(Integer defaultLifetime) {
        this(defaultLifetime, null, null);
    }

    public TimedVFSCache(Integer defaultLifetime, Boolean threadSafe, Integer resolution) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
        this.resolution = resolution;
    }

    protected CachePolicy createCachePolicy() {
        if (this.defaultLifetime == null) {
            this.defaultLifetime = TimedVFSCache.parseInteger(TimedVFSCache.readSystemProperty("jboss.vfs.cache.TimedPolicyCaching.lifetime", null));
        }
        if (this.threadSafe == null) {
            this.threadSafe = Boolean.valueOf(TimedVFSCache.readSystemProperty("jboss.vfs.cache.TimedPolicyCaching.threadSafe", Boolean.TRUE.toString()));
        }
        if (this.resolution == null) {
            this.resolution = TimedVFSCache.parseInteger(TimedVFSCache.readSystemProperty("jboss.vfs.cache.TimedPolicyCaching.resolution", null));
        }
        this.log.debug((Object)("Creating timed cache policy, lifetime: " + this.defaultLifetime + ", threadSafe: " + this.threadSafe + ", resolution: " + this.resolution));
        if (this.defaultLifetime == null) {
            return new TimedCachePolicy();
        }
        if (this.resolution != null) {
            return new TimedCachePolicy(this.defaultLifetime.intValue(), this.threadSafe.booleanValue(), this.resolution.intValue());
        }
        return new TimedCachePolicy(this.defaultLifetime.intValue());
    }

    public void setDefaultLifetime(Integer defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public void setThreadSafe(Boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }
}

