/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.copy;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.spi.TempInfo;
import org.jboss.virtual.spi.VFSContext;

public class TempContext
extends FileSystemContext {
    private VFSContext oldContext;
    private String relativePath;

    public TempContext(File file, VFSContext oldContext, String relativePath) throws IOException, URISyntaxException {
        super(file);
        this.oldContext = oldContext;
        this.relativePath = relativePath;
        if (!relativePath.endsWith("/")) {
            this.relativePath = this.relativePath + "/";
        }
    }

    public TempInfo getTempInfo(String path) {
        TempInfo tempInfo = super.getTempInfo(path);
        if (tempInfo != null) {
            return tempInfo;
        }
        return this.oldContext.getTempInfo(this.relativePath + path);
    }

    public void cleanupTempInfo(String path) {
        super.cleanupTempInfo(path);
        this.oldContext.cleanupTempInfo(this.relativePath + path);
    }
}

