/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.spi.registry;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.registry.VFSRegistryBuilder;

public abstract class VFSRegistry {
    public static VFSRegistry getInstance() {
        return VFSRegistryBuilder.getInstance();
    }

    public abstract void addContext(VFSContext var1);

    public abstract void removeContext(VFSContext var1);

    public abstract VFSContext getContext(URI var1) throws IOException;

    public VFSContext getContext(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            return this.getContext(VFSUtils.toURI(url));
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public abstract VirtualFile getFile(URI var1) throws IOException;

    public VirtualFile getFile(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            return this.getFile(VFSUtils.toURI(url));
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

