/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileAssembly;
import org.jboss.vfs.spi.FileSystem;

public class AssemblyFileSystem
implements FileSystem {
    private static final Logger log = Logger.getLogger((String)"org.jboss.vfs.assembly");
    private final VirtualFileAssembly assembly;

    public AssemblyFileSystem(VirtualFileAssembly assembly) {
        this.assembly = assembly;
        log.tracef("Constructed a new assembly filesystem for %s", new Object[]{assembly});
    }

    @Override
    public File getFile(VirtualFile mountPoint, VirtualFile target) throws IOException {
        return this.getExistingFile(mountPoint, target).getPhysicalFile();
    }

    @Override
    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        return assemblyFile != null && assemblyFile.delete();
    }

    @Override
    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        if (mountPoint.equals(target)) {
            return true;
        }
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        if (assemblyFile != null) {
            return assemblyFile.exists();
        }
        return this.assembly.contains(mountPoint, target);
    }

    @Override
    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        return assemblyFile != null && assemblyFile.isFile();
    }

    @Override
    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        if (assemblyFile == null) {
            return new ArrayList<String>(this.assembly.getChildNames(mountPoint, target));
        }
        LinkedList<String> directoryEntries = new LinkedList<String>();
        for (VirtualFile child : assemblyFile.getChildren()) {
            directoryEntries.add(child.getName());
        }
        return directoryEntries;
    }

    @Override
    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        return assemblyFile == null ? 0L : assemblyFile.getLastModified();
    }

    @Override
    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        return assemblyFile == null ? 0L : assemblyFile.getSize();
    }

    @Override
    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        if (mountPoint.equals(target)) {
            return true;
        }
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        if (assemblyFile != null) {
            return assemblyFile.isDirectory();
        }
        return this.assembly.contains(mountPoint, target);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public InputStream openInputStream(VirtualFile mountPoint, VirtualFile target) throws IOException {
        return this.getExistingFile(mountPoint, target).openStream();
    }

    @Override
    public void close() throws IOException {
        log.tracef("Closing assembly filesystem %s", new Object[]{this});
        this.assembly.close();
    }

    @Override
    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        if (assemblyFile == null) {
            return null;
        }
        return assemblyFile.getCodeSigners();
    }

    private VirtualFile getExistingFile(VirtualFile mountPoint, VirtualFile target) throws FileNotFoundException {
        VirtualFile assemblyFile = this.assembly.getFile(mountPoint, target);
        if (assemblyFile == null) {
            throw new FileNotFoundException(target.getPathName());
        }
        return assemblyFile;
    }
}

