/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;

public final class RealFileSystem
implements FileSystem {
    private static final Logger log = Logger.getLogger((String)"org.jboss.vfs.real");
    public static final RealFileSystem ROOT_INSTANCE = new RealFileSystem(new File(""));
    private static final boolean NEEDS_CONVERSION = File.separatorChar != '/';
    private final File realRoot;

    public RealFileSystem(File realRoot) {
        this.realRoot = realRoot;
        log.tracef("Constructed real filesystem at root %s", new Object[]{realRoot});
    }

    @Override
    public InputStream openInputStream(VirtualFile mountPoint, VirtualFile target) throws IOException {
        return new FileInputStream(this.getFile(mountPoint, target));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public File getFile(VirtualFile mountPoint, VirtualFile target) {
        if (mountPoint.equals(target)) {
            return this.realRoot;
        }
        if (NEEDS_CONVERSION) {
            return new File(this.realRoot, target.getPathNameRelativeTo(mountPoint).replace('/', File.separatorChar));
        }
        return new File(this.realRoot, target.getPathNameRelativeTo(mountPoint));
    }

    @Override
    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        return this.getFile(mountPoint, target).delete();
    }

    @Override
    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        return this.getFile(mountPoint, target).length();
    }

    @Override
    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        return this.getFile(mountPoint, target).lastModified();
    }

    @Override
    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        return this.getFile(mountPoint, target).exists();
    }

    @Override
    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        return this.getFile(mountPoint, target).isFile();
    }

    @Override
    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        return this.getFile(mountPoint, target).isDirectory();
    }

    @Override
    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        String[] names = this.getFile(mountPoint, target).list();
        return names == null ? Collections.emptyList() : Arrays.asList(names);
    }

    @Override
    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

