/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.InputStream;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.LazyInputStream;
import org.xml.sax.InputSource;

public class VFSInputSource
extends InputSource {
    private VirtualFile file;

    public VFSInputSource(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    @Override
    public String getSystemId() {
        try {
            return VFSUtils.getVirtualURI(this.file).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getByteStream() {
        return new LazyInputStream(this.file);
    }

    public String toString() {
        return this.file.getPathName();
    }
}

