/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.adminclient;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.SimpleCompletor;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.jboss.adminclient.command.ClientCommand;
import org.jboss.adminclient.command.ConnectCommand;
import org.jboss.adminclient.command.DisconnectCommand;
import org.jboss.adminclient.command.HelpCommand;
import org.jboss.adminclient.command.ListComponentsCommand;
import org.jboss.adminclient.command.ListDeploymentsCommand;
import org.jboss.adminclient.command.LoadCommand;
import org.jboss.adminclient.command.QuitCommand;
import org.jboss.adminclient.command.ReloadCommand;
import org.jboss.adminclient.connection.ProfileServiceConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminClientMain {
    private static Class[] COMMAND_CLASSES = new Class[]{ConnectCommand.class, DisconnectCommand.class, HelpCommand.class, ListComponentsCommand.class, ListDeploymentsCommand.class, LoadCommand.class, QuitCommand.class, ReloadCommand.class};
    private static final Map<String, ClientCommand> COMMANDS = new TreeMap<String, ClientCommand>();
    private Thread inputLoopThread;
    private BufferedReader inputReader;
    private ConsoleReader consoleReader;
    private boolean stdinInput = true;
    private PrintWriter outputWriter = new PrintWriter(System.out, true);
    private ProfileServiceConnection connection;
    String host;
    Integer port;
    String username;
    String password;
    boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AdminClientMain main = new AdminClientMain();
        main.processArguments(args);
        main.inputLoop();
    }

    public AdminClientMain() throws Exception {
        this.consoleReader = new ConsoleReader();
        this.consoleReader.addCompletor((Completor)new SimpleCompletor(COMMANDS.keySet().toArray(new String[COMMANDS.size()])));
        this.consoleReader.addCompletor((Completor)new ArgumentCompletor(new Completor[]{new SimpleCompletor("help"), new SimpleCompletor(COMMANDS.keySet().toArray(new String[COMMANDS.size()]))}));
        this.consoleReader.setUsePagination(true);
    }

    public void start() {
        this.outputWriter = new PrintWriter(System.out);
    }

    public String getUserInput(String prompt) {
        boolean useDefaultPrompt;
        String inputString = "";
        boolean bl = useDefaultPrompt = prompt == null;
        while (inputString != null && inputString.trim().length() == 0) {
            if (prompt == null) {
                prompt = this.isConnected() ? this.host + ":" + this.port + "> " : "disconnected> ";
            }
            try {
                this.outputWriter.flush();
                inputString = this.consoleReader.readLine(prompt);
            }
            catch (Exception e) {
                inputString = null;
            }
        }
        if (inputString != null) {
            if (!this.stdinInput) {
                this.outputWriter.println(inputString);
            }
        } else if (!this.stdinInput) {
            try {
                this.inputReader.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return inputString;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.getConnectionProvider().isConnected();
    }

    private void inputLoop() {
        Runnable loopRunnable = new Runnable(){

            public void run() {
                String cmd;
                boolean continueRunning;
                while (continueRunning = AdminClientMain.this.executeCommand(cmd = AdminClientMain.this.getUserInput(null))) {
                }
            }
        };
        this.inputLoopThread = new Thread(loopRunnable);
        this.inputLoopThread.setName("JBoss AS Admin Client Prompt Input Thread");
        this.inputLoopThread.setDaemon(false);
        this.inputLoopThread.start();
    }

    private boolean executeCommand(String cmd) {
        boolean continueRunning;
        try {
            String[] cmdArgs = this.parseCommandLine(cmd);
            continueRunning = this.executeCommand(cmdArgs);
        }
        catch (RuntimeException e) {
            e.printStackTrace(this.getPrintWriter());
            continueRunning = true;
        }
        return continueRunning;
    }

    private boolean executeCommand(String[] args) {
        block7: {
            String commandName = args[0];
            if (COMMANDS.containsKey(commandName)) {
                ClientCommand command = COMMANDS.get(commandName);
                if (command.isConnectionRequired() && !this.isConnected()) {
                    this.outputWriter.println("The '" + commandName + "' command requires a connection. Please run the 'connect' command first.");
                    return true;
                }
                String[] params = new String[args.length - 1];
                System.arraycopy(args, 1, params, 0, args.length - 1);
                OptionParser optionParser = command.getOptionParser();
                optionParser.acceptsAll(AdminClientMain.asList("h", "?", "help"), "display help");
                OptionSet options = optionParser.parse(params);
                if (options.has("help")) {
                    try {
                        optionParser.printHelpOn((Writer)this.outputWriter);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                try {
                    return command.execute(this, options);
                }
                catch (Exception e) {
                    this.getPrintWriter().write("Command failed: " + e.getLocalizedMessage());
                    e.printStackTrace(this.getPrintWriter());
                    break block7;
                }
            }
            this.outputWriter.println("Unknown command: " + commandName);
        }
        return true;
    }

    private String[] parseCommandLine(String cmdLine) {
        ByteArrayInputStream in = new ByteArrayInputStream(cmdLine.getBytes());
        StreamTokenizer strtok = new StreamTokenizer(new InputStreamReader(in));
        ArrayList<String> args = new ArrayList<String>();
        boolean keepGoing = true;
        strtok.ordinaryChars(48, 57);
        strtok.ordinaryChar(46);
        strtok.ordinaryChar(45);
        strtok.ordinaryChar(39);
        strtok.wordChars(33, 127);
        strtok.quoteChar(34);
        while (keepGoing) {
            int nextToken;
            try {
                nextToken = strtok.nextToken();
            }
            catch (IOException e) {
                nextToken = -1;
            }
            if (nextToken == -3) {
                args.add(strtok.sval);
                continue;
            }
            if (nextToken == 34) {
                args.add(strtok.sval);
                continue;
            }
            if (nextToken != -1 && nextToken != 10) continue;
            keepGoing = false;
        }
        return args.toArray(new String[args.size()]);
    }

    private void displayUsage() {
        this.outputWriter.println("rhq-client.sh [-h] [-u user] [-p pass] [-s host] [-t port] [-f file]");
    }

    void processArguments(String[] args) throws IllegalArgumentException, IOException {
        OptionParser optionParser = new OptionParser(){
            {
                this.acceptsAll(AdminClientMain.asList(new String[]{"H", "host"})).withRequiredArg().ofType(String.class).describedAs("the JBoss AS instance's JNP host (may be a hostname or an IP address)");
                this.acceptsAll(AdminClientMain.asList(new String[]{"P", "port"})).withRequiredArg().ofType(Integer.class).describedAs("the JBoss AS instance's the JNP port");
                this.acceptsAll(AdminClientMain.asList(new String[]{"u", "username"})).withRequiredArg().ofType(String.class).describedAs("the username used to authenticate against the JBoss AS Profile Service");
                this.acceptsAll(AdminClientMain.asList(new String[]{"p", "password"})).withRequiredArg().ofType(String.class).describedAs("the password used to authenticate against the JBoss AS Profile Service");
                this.acceptsAll(AdminClientMain.asList(new String[]{"e", "execute"})).withRequiredArg().ofType(String.class).describedAs("a semicolon-separated list of commands to execute");
                this.acceptsAll(AdminClientMain.asList(new String[]{"h", "?", "help"}), "display help");
                this.acceptsAll(AdminClientMain.asList(new String[]{"v", "verbose"}), "enable verbose output");
            }
        };
        OptionSet options = optionParser.parse(args);
        if (options.has("help")) {
            optionParser.printHelpOn((Writer)this.outputWriter);
        }
        this.host = (String)options.valueOf("host");
        this.port = (Integer)options.valueOf("port");
        this.username = (String)options.valueOf("username");
        this.password = (String)options.valueOf("password");
        this.verbose = options.has("verbose");
        String execute = (String)options.valueOf("execute");
        if (execute != null) {
            String[] tokens;
            for (String token : tokens = execute.split(";")) {
                String commandName = token.trim();
                if (this.executeCommand(commandName)) continue;
                System.exit(0);
            }
        }
        ClientCommand connectCommand = COMMANDS.get("connect");
        OptionParser connectOptionParser = connectCommand.getOptionParser();
        ArrayList<String> connectOptions = new ArrayList<String>();
        if (this.host != null) {
            connectOptions.add("--host");
            connectOptions.add(this.host);
        }
        if (this.port != null) {
            connectOptions.add("--port");
            connectOptions.add(this.port.toString());
        }
        if (this.username != null) {
            connectOptions.add("--username");
            connectOptions.add(this.username);
        }
        if (this.password != null) {
            connectOptions.add("--password");
            connectOptions.add(this.password);
        }
        OptionSet connectOptionSet = connectOptionParser.parse(connectOptions.toArray(new String[connectOptions.size()]));
        connectCommand.execute(this, connectOptionSet);
    }

    public PrintWriter getPrintWriter() {
        return this.outputWriter;
    }

    public int getConsoleWidth() {
        return this.consoleReader.getTermwidth();
    }

    public Map<String, ClientCommand> getCommands() {
        return COMMANDS;
    }

    public ProfileServiceConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ProfileServiceConnection connection) {
        this.connection = connection;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private static <T> List<T> asList(T ... items) {
        return Arrays.asList(items);
    }

    static {
        for (Class commandClass : COMMAND_CLASSES) {
            try {
                ClientCommand command = (ClientCommand)commandClass.newInstance();
                COMMANDS.put(command.getName(), command);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

