/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.adminclient.command;

import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.jboss.adminclient.AdminClientMain;
import org.jboss.adminclient.command.AbstractClientCommand;
import org.jboss.deployers.spi.management.ManagementView;

public class ListDeploymentsCommand
extends AbstractClientCommand {
    public String getName() {
        return "listdeployments";
    }

    public OptionParser getOptionParser() {
        return new OptionParser(){
            {
                this.acceptsAll(ListDeploymentsCommand.this.asList("t", "type")).withRequiredArg().ofType(String.class).describedAs("an optional type (e.g. war) to filter by");
            }
        };
    }

    public boolean execute(AdminClientMain client, OptionSet options) {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new IllegalArgumentException("Usage: " + this.getName() + " [--type <type>]");
        }
        String type = (String)options.valueOf("type");
        ManagementView managementView = client.getConnection().getManagementView();
        Set deploymentNames = type != null ? managementView.getDeploymentNamesForType(type) : managementView.getDeploymentNames();
        for (String deploymentName : deploymentNames) {
            client.getPrintWriter().println(deploymentName);
        }
        return true;
    }

    public String getHelp() {
        return "List all deployments, or, if a type is specified, all deployments of that type.";
    }

    public String getDetailedHelp() {
        return null;
    }

    public boolean isConnectionRequired() {
        return true;
    }
}

