/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javassist.bytecode.ClassFile;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectAnnotationLoaderStrategy;
import org.jboss.aop.microcontainer.beans.metadata.AOPDeployment;
import org.jboss.aop.microcontainer.beans.metadata.MicrocontainerAnnotationLoaderStrategy;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPAnnotationMetaDataParserDeployer
extends AbstractDeployer {
    public AOPAnnotationMetaDataParserDeployer(int xmlParserOrder) {
        super.setOutput(AOPDeployment.class);
        super.setStage(DeploymentStages.PARSE);
        super.setRelativeOrder(xmlParserOrder + 1);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            this.log.trace((Object)("Not a vfs deployment: " + unit.getName()));
            return;
        }
        if (!unit.getSimpleName().endsWith(".aop")) {
            this.log.trace((Object)("Unit name does not end in .aop: " + unit.getSimpleName()));
            return;
        }
        this.internalDeploy((VFSDeploymentUnit)unit);
    }

    private void internalDeploy(VFSDeploymentUnit unit) throws DeploymentException {
        MicrocontainerAnnotationLoaderStrategy strategy = new MicrocontainerAnnotationLoaderStrategy();
        AspectAnnotationLoader loader = new AspectAnnotationLoader(null, (AspectAnnotationLoaderStrategy)strategy);
        List<VirtualFile> files = this.getClasses(unit);
        for (VirtualFile file : files) {
            try {
                ClassFile cf = this.loadClassFile(file);
                this.log.debug((Object)("Deploying possibly annotated class " + cf.getName()));
                loader.deployClassFile(cf);
            }
            catch (Exception e) {
                throw new DeploymentException("Error reading annotations for " + file, (Throwable)e);
            }
        }
        List factories = strategy.getFactories();
        AOPDeployment deployment = (AOPDeployment)unit.getAttachment(AOPDeployment.class);
        if (factories != null && factories.size() > 0) {
            if (deployment == null) {
                deployment = new AOPDeployment();
                unit.getTransientManagedObjects().addAttachment(AOPDeployment.class.getName(), (Object)deployment, AOPDeployment.class);
                deployment.setBeanFactories(new ArrayList());
            }
            deployment.getBeanFactories().addAll(factories);
        }
    }

    private ClassFile loadClassFile(VirtualFile file) {
        FilterInputStream din = null;
        ClassFile cf = null;
        try {
            InputStream in = file.openStream();
            din = new DataInputStream(new BufferedInputStream(in));
            cf = new ClassFile((DataInputStream)din);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + file, e);
        }
        finally {
            try {
                din.close();
            }
            catch (IOException ignored) {}
        }
        return cf;
    }

    private List<VirtualFile> getClasses(VFSDeploymentUnit unit) {
        VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        ClassFileFilter filter = new ClassFileFilter();
        SuffixesExcludeFilter noJars = new SuffixesExcludeFilter((Collection)JarUtils.getSuffixes());
        va.setRecurseFilter((VirtualFileFilter)noJars);
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor((VirtualFileFilter)filter, va);
        for (VirtualFile vf : unit.getClassPath()) {
            try {
                vf.visit((VirtualFileVisitor)visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return visitor.getMatched();
    }

    private static class ClassFileFilter
    implements VirtualFileFilter {
        private ClassFileFilter() {
        }

        public boolean accepts(VirtualFile file) {
            try {
                return file.isLeaf() && file.getName().endsWith(".class");
            }
            catch (IOException e) {
                throw new RuntimeException("Error visiting file: " + file.getName(), e);
            }
        }
    }
}

