/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.util.HashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.asintegration.jboss5.ScopedVFSClassLoaderDomain;
import org.jboss.aop.asintegration.jboss5.VFSClassLoaderDomainRegistry;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.classpool.ExtraClassPoolFactoryParameters;
import org.jboss.aop.domain.DomainInitializer;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;

public class VFSClassLoaderScopingPolicy
implements AOPClassLoaderScopingPolicy,
DomainInitializer {
    static Logger log = Logger.getLogger(VFSClassLoaderScopingPolicy.class);
    VFSClassLoaderDomainRegistry registry = new VFSClassLoaderDomainRegistry();

    public Domain initializeDomain(VFSDeploymentUnit unit) {
        Module module = (Module)unit.getTopLevel().getAttachment(Module.class);
        ClassLoader loader = unit.getClassLoader();
        ClassLoader topLoader = unit.getTopLevel().getClassLoader();
        boolean isWar = unit.isAttachmentPresent("org.jboss.metadata.web.jboss.JBossWebMetaData");
        if (isWar && loader != topLoader) {
            ScopedVFSClassLoaderDomain scopedDomain = (ScopedVFSClassLoaderDomain)this.registry.getRegisteredDomain(loader);
            if (scopedDomain == null) {
                scopedDomain = (ScopedVFSClassLoaderDomain)this.registry.getRegisteredDomain(topLoader);
            }
            if (scopedDomain != null) {
                this.registry.initMapsForLoader(loader, module, scopedDomain);
            }
            this.registerClassLoader(module, isWar, loader);
            return scopedDomain;
        }
        ScopedVFSClassLoaderDomain scopedDomain = (ScopedVFSClassLoaderDomain)this.registry.getRegisteredDomain(loader);
        if (scopedDomain == null) {
            if (!module.getDeterminedDomainName().equals("DefaultDomain")) {
                ClassLoaderSystem system = ClassLoaderSystem.getInstance();
                String domainName = module.getDeterminedDomainName();
                ClassLoaderDomain domain = system.getDomain(domainName);
                boolean parentDelegation = module.isJ2seClassLoadingCompliance();
                String name = String.valueOf(System.identityHashCode(loader));
                scopedDomain = new ScopedVFSClassLoaderDomain(loader, name, parentDelegation, AspectManager.getTopLevelAspectManager(), false, domain, this.registry);
            }
            this.registry.initMapsForLoader(loader, module, scopedDomain);
            this.registerClassLoader(module, isWar, loader);
        }
        return scopedDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerClassLoader(Module module, boolean isWar, ClassLoader loader) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put(Module.class, module);
        properties.put("IsWebCl", isWar ? Boolean.TRUE : Boolean.FALSE);
        ExtraClassPoolFactoryParameters.pushThreadProperties(properties);
        try {
            AspectManager.instance().registerClassLoader(loader);
        }
        finally {
            ExtraClassPoolFactoryParameters.popThreadProperties();
        }
    }

    public Domain getDomain(ClassLoader classLoader, AspectManager parent) {
        Domain domain = this.registry.getRegisteredDomain(classLoader);
        if (domain != null) {
            return domain;
        }
        return null;
    }

    public Domain getTopLevelDomain(AspectManager parent) {
        Thread.currentThread().getContextClassLoader();
        return null;
    }
}

