/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aspects.versioned.DistributedSynchronizationManager;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.VersionManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public class DistributedTxCache {
    protected static final Class[] INSERT_TYPES = new Class[]{Object.class, Object.class};
    protected static final Class[] REMOVE_TYPES = new Class[]{Object.class};
    protected static Logger log = Logger.getLogger(DistributedTxCache.class);
    protected long lockTimeout;
    protected DistributedSynchronizationManager synchManager;
    protected DistributedVersionManager versionManager;
    protected String partitionName;
    protected HAPartition partition;
    protected String cacheName;
    protected LRUCache cache = null;
    protected int maxSize;

    public DistributedTxCache(int maxSize, long lockTimeout, String cacheName) {
        this(maxSize, lockTimeout, cacheName, "DefaultPartition");
    }

    public DistributedTxCache(int maxSize, long lockTimeout, String cacheName, String pName) {
        this.lockTimeout = lockTimeout;
        this.partitionName = pName;
        this.maxSize = maxSize;
        this.cacheName = "DistributedTxCache/" + cacheName;
    }

    protected HAPartition findHAPartitionWithName(String name) throws Exception {
        return HAPartitionLocator.getHAPartitionLocator().getHAPartition(name, null);
    }

    public void create() throws Exception {
        this.partition = this.findHAPartitionWithName(this.partitionName);
        this.partition.registerRPCHandler(this.cacheName, (Object)this);
        this.synchManager = new DistributedSynchronizationManager(this.cacheName, null, this.partition);
        this.synchManager.versionManager = this.versionManager = new DistributedVersionManager(this.lockTimeout, this.synchManager);
        this.synchManager.create();
    }

    public synchronized void start() throws Exception {
        this.synchManager.start();
        this.pullState();
        if (this.cache == null) {
            this.cache = new LRUCache(this.maxSize);
        }
    }

    protected void pullState() throws Exception {
        Object[] args = new Object[0];
        ArrayList rsp = this.partition.callMethodOnCluster(this.cacheName, "getCurrentState", args, null, true);
        if (rsp.size() > 0) {
            this.setCurrentState((Serializable)rsp.get(0));
        }
    }

    public synchronized void _insert(Object key, Object obj) {
        this.cache.put(key, obj);
    }

    public void insert(Object key, Object obj) throws Exception {
        try {
            obj = this.versionManager.makeVersioned(obj);
            if (this.versionManager.isVersioned(obj)) {
                log.trace((Object)"Inserting versioned object");
                obj = VersionManager.getGUID((InstanceAdvised)obj);
            } else {
                log.trace((Object)"Inserting a non-Versioned object");
            }
            Object[] args = new Object[]{key, obj};
            this.partition.callMethodOnCluster(this.cacheName, "_insert", args, INSERT_TYPES, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public synchronized void _remove(Object key) {
        this.cache.remove(key);
    }

    public void remove(Object key) {
        Object[] args = new Object[]{key};
        try {
            this.partition.callMethodOnCluster(this.cacheName, "_remove", args, REMOVE_TYPES, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void _flush() {
        this.cache.clear();
    }

    public void flush(Object key) {
        Object[] args = new Object[]{};
        try {
            this.partition.callMethodOnCluster(this.cacheName, "_flush", args, null, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized Object get(Object key) {
        Object obj = this.cache.get(key);
        if (obj instanceof GUID) {
            GUID guid = (GUID)obj;
            obj = this.synchManager.getObject(guid);
        }
        return obj;
    }

    public Serializable getCurrentState() {
        log.trace((Object)"getCurrentState called on cache");
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentState(Serializable newState) {
        log.trace((Object)"setCurrentState called on cache");
        DistributedTxCache distributedTxCache = this;
        synchronized (distributedTxCache) {
            this.cache = (LRUCache)newState;
        }
    }

    private static class LRUCache
    extends LinkedHashMap {
        private static final long serialVersionUID = -402696519285213913L;
        private int maxSize;

        public LRUCache(int max) {
            super(16, 0.75f, true);
            this.maxSize = max;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

