/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.versioned.LockAttemptFailure;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public abstract class StateManager
implements Externalizable {
    public static final String STATE_MANAGER = "STATE_MANAGER";
    protected static Logger log = Logger.getLogger(StateManager.class);
    protected GUID guid;
    protected long timeout;
    protected transient ReadWriteLock lock = new ReentrantReadWriteLock();

    public static StateManager getStateManager(InstanceAdvised obj) {
        return (StateManager)obj._getInstanceAdvisor().getMetaData().getMetaData((Object)STATE_MANAGER, (Object)STATE_MANAGER);
    }

    public static void setStateManager(InstanceAdvised obj, StateManager manager) {
        obj._getInstanceAdvisor().getMetaData().addMetaData((Object)STATE_MANAGER, (Object)STATE_MANAGER, (Object)manager, PayloadKey.TRANSIENT);
    }

    public StateManager() {
    }

    public StateManager(GUID guid, long timeout) {
        this.guid = guid;
        this.timeout = timeout;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public void acquireWriteLock() {
        try {
            if (!this.lock.writeLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                throw new LockAttemptFailure("failed to acquire write lock: " + this.guid);
            }
            log.trace((Object)("writelock acquired for: " + this.guid));
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            throw new LockAttemptFailure("failed to acquire write lock: " + this.guid);
        }
    }

    public void acquireReadLock() {
        try {
            if (!this.lock.readLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                throw new LockAttemptFailure("failed to acquire read lock: " + this.guid);
            }
            log.trace((Object)("readlock acquired for: " + this.guid));
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            throw new LockAttemptFailure("failed to acquire read lock: " + this.guid);
        }
    }

    public void releaseReadLock() {
        this.lock.readLock().unlock();
        log.trace((Object)("readlock released for: " + this.guid));
    }

    public void releaseWriteLock() {
        this.lock.writeLock().unlock();
        log.trace((Object)("writelock released for: " + this.guid));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.guid);
        out.writeLong(this.timeout);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.guid = (GUID)in.readObject();
        this.timeout = in.readLong();
        this.lock = new ReentrantReadWriteLock();
    }
}

