/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.microcontainer;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.bootstrap.AbstractServerImpl;
import org.jboss.bootstrap.BootstrapMetaData;
import org.jboss.bootstrap.xml.BootstrapParser;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.plugins.event.AbstractEvent;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.util.StopWatch;

public class ServerImpl
extends AbstractServerImpl {
    public static String BOOTSTRAP_XML_NAME = "bootstrap.xml";
    private BasicBootstrap bootstrap;
    private Kernel kernel;
    private BasicXMLDeployer kernelDeployer;

    public Kernel getKernel() {
        return this.kernel;
    }

    protected void doStart(StopWatch watch) throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.kernel = bootstrap.getKernel();
        KernelController controller = this.kernel.getController();
        AbstractBeanMetaData metaData = new AbstractBeanMetaData("JBossServer", this.getClass().getName());
        InstallCallbackMetaData install = new InstallCallbackMetaData();
        install.setMethodName("addBootstrap");
        metaData.setInstallCallbacks(Collections.singletonList(install));
        UninstallCallbackMetaData uninstall = new UninstallCallbackMetaData();
        uninstall.setMethodName("removeBootstrap");
        metaData.setUninstallCallbacks(Collections.singletonList(uninstall));
        controller.install((BeanMetaData)metaData, (Object)this);
        URL configURL = this.getConfig().getServerConfigURL();
        URL url = this.getConfig().getBootstrapURL();
        if (url == null) {
            url = new URL(configURL, BOOTSTRAP_XML_NAME);
        }
        this.log.info((Object)("Starting Microcontainer, bootstrapURL=" + url));
        BootstrapMetaData bootstrapMetaData = BootstrapParser.parse(url);
        List<String> bootstrapURLs = bootstrapMetaData.getBootstrapURLs();
        if (bootstrapURLs == null || bootstrapURLs.isEmpty()) {
            throw new IllegalStateException("No bootstrap urls in " + url);
        }
        this.log.debug((Object)("BootstrapURLs=" + bootstrapURLs));
        this.kernelDeployer = new BasicXMLDeployer(this.kernel);
        try {
            for (String bootstrapURL : bootstrapURLs) {
                url = new URL(configURL, bootstrapURL);
                this.kernelDeployer.deploy(url);
            }
            this.kernelDeployer.validate();
            KernelEventManager eventMgr = this.kernel.getEventManager();
            AbstractEvent startEvent = new AbstractEvent((Object)eventMgr, "org.jboss.system.server.started", 0L, System.currentTimeMillis(), (Object)new Long(watch.getLapTime()));
            eventMgr.fireKernelEvent((KernelEvent)startEvent);
            this.bootstrap = bootstrap;
        }
        catch (Throwable t) {
            try {
                this.kernelDeployer.shutdown();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw t;
        }
    }

    protected void doShutdown() {
        try {
            if (this.bootstrap != null) {
                KernelEvent stopEvent = this.bootstrap.createEvent("org.jboss.system.server.stopped", null);
                this.bootstrap.fireKernelEvent(stopEvent);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error sending stop notification", t);
        }
        try {
            if (this.kernelDeployer != null) {
                this.kernelDeployer.shutdown();
                this.kernelDeployer = null;
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error stopping xml deployer", t);
        }
        try {
            Kernel currentKernel = null;
            if (this.kernel != null) {
                currentKernel = this.kernel;
                this.kernel = null;
            } else if (this.bootstrap != null) {
                currentKernel = this.bootstrap.getKernel();
            }
            this.bootstrap = null;
            if (currentKernel != null) {
                KernelController controller = currentKernel.getController();
                controller.shutdown();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error stopping xml deployer", t);
        }
    }
}

