/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.binding.remote;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import org.jboss.deployment.DeploymentException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.proxy.ClientMethodInterceptor;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.resource.binding.remote.RemoteConnectionFactoryHelper;
import org.jboss.resource.binding.remote.RemoteConnectionFactoryServiceMBean;
import org.jboss.resource.connectionmanager.ConnectionFactoryBindingService;
import org.jboss.system.Registry;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;

public class RemoteConnectionFactoryService
extends ConnectionFactoryBindingService
implements RemoteConnectionFactoryServiceMBean {
    private static Logger log = Logger.getLogger(RemoteConnectionFactoryService.class);
    private ObjectName jmxInvokerName;
    private Invoker delegateInvoker;
    private Object theProxy;
    private Map marshalledInvocationMapping = new HashMap();
    private Map objectMap = new HashMap();

    public ObjectName getJMXInvokerName() {
        return this.jmxInvokerName;
    }

    public void setJMXInvokerName(ObjectName jmxInvokerName) {
        this.jmxInvokerName = jmxInvokerName;
    }

    protected void startService() throws Exception {
        this.determineBindName();
        this.createConnectionFactory();
        if (this.jmxInvokerName != null) {
            this.createProxy();
            this.calculateHashes();
            this.bindConnectionFactory();
        } else {
            super.bindConnectionFactory();
        }
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object[] targetArguments;
        Method targetMethod;
        Class<?> targetClass;
        Object retVal;
        Object result = null;
        if (invocation instanceof MarshalledInvocation) {
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            mi.setMethodMap(this.marshalledInvocationMapping);
        }
        if (!((retVal = this.internalInvoke(targetClass = (targetMethod = invocation.getMethod()).getDeclaringClass(), targetMethod, targetArguments = invocation.getArguments(), invocation.getId())) instanceof Serializable) && retVal != null) {
            log.debug((Object)("Creating proxy for instance " + retVal));
            result = this.createProxy(retVal);
        }
        return result;
    }

    private Object internalInvoke(Class clazz, Method method, Object[] arguments, Object id) throws Exception {
        Object result = null;
        if (clazz.isAssignableFrom(this.cf.getClass())) {
            InitialContext initCtx = new InitialContext();
            Object boundCf = initCtx.lookup(this.bindName);
            result = method.invoke(boundCf, arguments);
            this.objectMap.put(Integer.valueOf(String.valueOf(result.hashCode())), result);
        } else {
            Object target = this.objectMap.get(id);
            if (target != null) {
                result = method.invoke(target, arguments);
                if (method.getName().equals("close")) {
                    this.objectMap.remove(id);
                }
            }
        }
        return result;
    }

    private void calculateHashes(Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> target = interfaces[i];
            Map m = MarshalledInvocation.methodToHashesMap(target);
            this.marshalledInvocationMapping.putAll(m);
        }
    }

    private void calculateHashes() {
        Class<?>[] cfInterfaces = this.cf.getClass().getInterfaces();
        for (int i = 0; i < cfInterfaces.length; ++i) {
            Class<?> clazz = cfInterfaces[i];
            Method[] methods = clazz.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method m = methods[j];
                Long hash = new Long(MarshalledInvocation.calculateHash((Method)m));
                this.marshalledInvocationMapping.put(hash, m);
            }
        }
    }

    private Object createProxy(Object value) throws Exception {
        this.delegateInvoker = (Invoker)Registry.lookup((Object)this.jmxInvokerName);
        log.debug((Object)("Using delegate: " + this.delegateInvoker + " for invoker=" + this.jmxInvokerName));
        this.calculateHashes(value.getClass());
        Class[] targetInterfaces = value.getClass().getInterfaces();
        ArrayList<Class> interceptorList = new ArrayList<Class>();
        Integer cacheID = new Integer(value.hashCode());
        String proxyBindingName = null;
        String jndiName = null;
        interceptorList.add(ClientMethodInterceptor.class);
        interceptorList.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object proxy = proxyFactory.createProxy((Object)cacheID, this.serviceName, this.delegateInvoker, jndiName, proxyBindingName, interceptorList, loader, targetInterfaces);
        this.objectMap.put(cacheID, value);
        return proxy;
    }

    private void createProxy() throws Exception {
        this.delegateInvoker = (Invoker)Registry.lookup((Object)this.jmxInvokerName);
        log.debug((Object)("Using delegate: " + this.delegateInvoker + " for invoker=" + this.jmxInvokerName));
        ObjectName serviceName = this.getServiceName();
        Integer nameHash = Integer.valueOf(String.valueOf(serviceName.hashCode()));
        Registry.bind((Object)nameHash, (Object)serviceName);
        Object cacheID = null;
        String proxyBindingName = null;
        String jndiName = null;
        Class[] connectionFactoryInterface = this.cf.getClass().getInterfaces();
        ArrayList<Class> interceptorList = new ArrayList<Class>();
        interceptorList.add(ClientMethodInterceptor.class);
        interceptorList.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        this.theProxy = proxyFactory.createProxy(cacheID, serviceName, this.delegateInvoker, jndiName, proxyBindingName, interceptorList, loader, connectionFactoryInterface);
    }

    protected void bindConnectionFactory() throws Exception {
        InitialContext initCtx = new InitialContext();
        try {
            NonSerializableFactory.rebind((String)this.bindName, (Object)this.cf);
            Referenceable referenceable = (Referenceable)this.cf;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.theProxy);
            oos.close();
            byte[] proxyBytes = baos.toByteArray();
            BinaryRefAddr dsAddr = new BinaryRefAddr("ProxyData", proxyBytes);
            String remoteFactoryName = RemoteConnectionFactoryHelper.class.getName();
            String localFactoryName = this.cf.getClass().getName();
            Reference dsRef = new Reference(localFactoryName, dsAddr, remoteFactoryName, null);
            referenceable.setReference(dsRef);
            baos.reset();
            ObjectOutputStream oos2 = new ObjectOutputStream(baos);
            oos2.writeObject(RemoteConnectionFactoryHelper.vmID);
            oos2.close();
            byte[] id = baos.toByteArray();
            BinaryRefAddr localAddr = new BinaryRefAddr("VMID", id);
            dsRef.add(localAddr);
            StringRefAddr jndiRef = new StringRefAddr("JndiName", this.bindName);
            dsRef.add(jndiRef);
            Util.rebind((Context)initCtx, (String)this.bindName, (Object)this.cf);
            log.info((Object)("Bound ConnectionManager '" + this.serviceName + "' to JNDI name '" + this.bindName + "'"));
        }
        catch (NamingException e) {
            log.error((Object)("Could not bind ConnectionFactory into jndi: " + this.bindName), (Throwable)e);
            throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.bindName, (Throwable)e);
        }
        finally {
            if (initCtx != null) {
                initCtx.close();
            }
        }
    }
}

