/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.resource.deployers;

import org.jboss.deployers.vfs.spi.deployer.ObjectModelFactoryDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.resource.deployment.ResourceAdapterObjectModelFactory;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.repository.JCAMetaDataRepository;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;

/**
 * RARParserDeployer.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class RARParserDeployer extends ObjectModelFactoryDeployer<ConnectorMetaData>
{
   /** The metadata repsoitory */
   private JCAMetaDataRepository metaDataRepository;
      
   /**
    * Create a new RARParserDeployer.
    */
   public RARParserDeployer()
   {
      super(ConnectorMetaData.class);
      setName("ra.xml");
   }

   public JCAMetaDataRepository getMetaDataRepository()
   {
      return metaDataRepository;
   }

   public void setMetaDataRepository(JCAMetaDataRepository metaDataRepository)
   {
      this.metaDataRepository = metaDataRepository;
   }

   protected ObjectModelFactory getObjectModelFactory(ConnectorMetaData root)
   {
      return new ResourceAdapterObjectModelFactory();
   }

   @Override
   protected void init(VFSDeploymentUnit unit, ConnectorMetaData cmd, VirtualFile file) throws Exception
   {
      cmd.setURL(file.toURL());
      VFSDeploymentUnit parent = unit.getParent();
      String name = unit.getSimpleName();
      if( parent != null )
         name = parent.getSimpleName() + "#" + name;
      metaDataRepository.addConnectorMetaData(name, cmd);
   }
}
