/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.resource.statistic.pool;

import org.jboss.resource.statistic.JBossStatistics;

/**
 * A SubPoolStatisticGroup.
 * 
 * @author <a href="weston.price@jboss.com">Weston Price</a>
 * @version $Revision: 44968 $
 */
public class JBossSubPoolStatistics implements JBossStatistics
{

   /** The serialVersionUID */
   private static final long serialVersionUID = -5089686321382050654L;

   /** The trackByTxn */
   private Boolean trackByTxn;
   
   /** The availableConnections */
   private long availableConnections;
   
   /** The maxConnectionsInUse */
   private int maxConnectionsInUse;
   
   /** The connectionsInUse */
   private int connectionsInUse;
   
   /** The connectionsDestroyed */
   private int connectionsDestroyed;

   /** The totalBlockTime */
   private long totalBlockTime;
   
   /** The averageBlockTime */
   private long averageBlockTime;
   
   /** The totalTimedOut */
   private int totalTimedOut;
   
   /**
    * Get the availableConnections.
    * 
    * @return the availableConnections.
    */
   public long getAvailableConnections()
   {
      return availableConnections;
   }


   /**
    * Set the availableConnections.
    * 
    * @param availableConnections The availableConnections to set.
    */
   public void setAvailableConnections(long availableConnections)
   {
      this.availableConnections = availableConnections;
   }


   /**
    * Get the connectionsDestroyed.
    * 
    * @return the connectionsDestroyed.
    */
   public int getConnectionsDestroyed()
   {
      return connectionsDestroyed;
   }


   /**
    * Set the connectionsDestroyed.
    * 
    * @param connectionsDestroyed The connectionsDestroyed to set.
    */
   public void setConnectionsDestroyed(int connectionsDestroyed)
   {
      this.connectionsDestroyed = connectionsDestroyed;
   }


   /**
    * Get the connectionsInUse.
    * 
    * @return the connectionsInUse.
    */
   public int getConnectionsInUse()
   {
      return connectionsInUse;
   }


   /**
    * Set the connectionsInUse.
    * 
    * @param connectionsInUse The connectionsInUse to set.
    */
   public void setConnectionsInUse(int connectionsInUse)
   {
      this.connectionsInUse = connectionsInUse;
   }


   /**
    * Get the maxConnectionsInUse.
    * 
    * @return the maxConnectionsInUse.
    */
   public int getMaxConnectionsInUse()
   {
      return maxConnectionsInUse;
   }


   /**
    * Set the maxConnectionsInUse.
    * 
    * @param maxConnectionsInUse The maxConnectionsInUse to set.
    */
   public void setMaxConnectionsInUse(int maxConnectionsInUse)
   {
      this.maxConnectionsInUse = maxConnectionsInUse;
   }


   /**
    * Get the trackByTxn.
    * 
    * @return the trackByTxn.
    */
   public Boolean getTrackByTxn()
   {
      return trackByTxn;
   }


   /**
    * Set the trackByTxn.
    * 
    * @param trackByTxn The trackByTxn to set.
    */
   public void setTrackByTxn(Boolean trackByTxn)
   {
      this.trackByTxn = trackByTxn;
   }


   public String toString()
   {
      final StringBuffer statBuff = new StringBuffer();      
      statBuff.append("Track By Transaction: " + getTrackByTxn() + "\n");
      statBuff.append("Available Connections Count: " + getAvailableConnections() + "\n");
      statBuff.append("Max Connections In Use Count:" + getMaxConnectionsInUse() + "\n");
      statBuff.append("Connections Destroyed Count:" + getConnectionsDestroyed() + "\n");
      statBuff.append("Connections In Use Count:" + getConnectionsInUse() + "\n");
      statBuff.append("Total Block Time:" + getTotalBlockTime() + "\n");
      statBuff.append("Average Block Time For Sub Pool:" + getTotalBlockTime() + "\n");

      statBuff.append("Total Timed Out:" + getTotalTimedOut() + "\n");

      return statBuff.toString();
   }


   /**
    * Get the totalBlockTime.
    * 
    * @return the totalBlockTime.
    */
   public long getTotalBlockTime()
   {
      return totalBlockTime;
   }


   /**
    * Set the totalBlockTime.
    * 
    * @param totalBlockTime The totalBlockTime to set.
    */
   public void setTotalBlockTime(long totalBlockTime)
   {
      this.totalBlockTime = totalBlockTime;
   }


   /**
    * Get the totalTimedOut.
    * 
    * @return the totalTimedOut.
    */
   public int getTotalTimedOut()
   {
      return totalTimedOut;
   }


   /**
    * Set the totalTimedOut.
    * 
    * @param totalTimedOut The totalTimedOut to set.
    */
   public void setTotalTimedOut(int totalTimedOut)
   {
      this.totalTimedOut = totalTimedOut;
   }


   /**
    * Get the averageBlockTime.
    * 
    * @return the averageBlockTime.
    */
   public long getAverageBlockTime()
   {
      return averageBlockTime;
   }


   /**
    * Set the averageBlockTime.
    * 
    * @param averageBlockTime The averageBlockTime to set.
    */
   public void setAverageBlockTime(long averageBlockTime)
   {
      this.averageBlockTime = averageBlockTime;
   }
   
}
