/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.builder;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.resource.connectionmanager.NoTxConnectionManager;
import org.jboss.resource.connectionmanager.TxConnectionManager;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManagerBuilder
extends AbstractBuilder {
    private static final String CCM_JMX = "jboss.jca:service=CachedConnectionManager";
    private static final String JAAS_JMX = "jboss.security:service=JaasSecurityManager";
    private static final String TM_JMX = "jboss:service=TransactionManager";
    private static final String POOL_JMX = "jboss.jca:service=ManagedConnectionPool,name=";

    @Override
    public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md) {
        ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attribute = null;
        attribute = this.buildSimpleAttribute("JndiName", md.getJndiName());
        attributes.add(attribute);
        attribute = this.buildDependencyAttribute("CachedConnectionManager", CCM_JMX);
        attributes.add(attribute);
        attribute = this.buildDependencyAttribute("JaasSecurityManagerService", JAAS_JMX);
        attributes.add(attribute);
        attribute = this.buildDependencyAttribute("ManagedConnectionPool", POOL_JMX + md.getJndiName());
        attributes.add(attribute);
        if (!md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE)) {
            attribute = this.buildDependencyAttribute("TransactionManagerService", TM_JMX);
            attributes.add(attribute);
            attribute = this.buildSimpleAttribute("LocalTransactions", String.valueOf(md.getLocalTransactions()));
            attributes.add(attribute);
            attribute = this.buildSimpleAttribute("TrackConnectionByTx", String.valueOf(md.getTrackConnectionByTransaction()));
            attributes.add(attribute);
            if (md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.XA)) {
                // empty if block
            }
        }
        return attributes;
    }

    @Override
    public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md) {
        String cmType = "jboss.jca:service=";
        String jndiName = md.getJndiName();
        cmType = md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE) ? cmType + "NoTxCM,name=" + jndiName : (md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.LOCAL) ? (md instanceof DataSourceDeploymentMetaData ? cmType + "LocalTxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName) : (md instanceof DataSourceDeploymentMetaData ? cmType + "XATxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName));
        return ObjectNameFactory.create((String)cmType);
    }

    @Override
    public String getCode(ManagedConnectionFactoryDeploymentMetaData md) {
        String code = null;
        code = md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE) ? NoTxConnectionManager.class.getName() : TxConnectionManager.class.getName();
        return code;
    }
}

