/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.inflow.DLQHandler;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
import org.jboss.resource.adapter.jms.inflow.JmsServerSessionPool;

public class JmsServerSession
implements ServerSession,
MessageListener,
Work,
WorkListener {
    private static final Logger log = Logger.getLogger(JmsServerSession.class);
    JmsServerSessionPool pool;
    boolean transacted;
    int acknowledge;
    Session session;
    XASession xaSession;
    MessageEndpoint endpoint;
    DLQHandler dlqHandler;
    TransactionDemarcationStrategy txnStrategy;

    public JmsServerSession(JmsServerSessionPool pool) {
        this.pool = pool;
    }

    public void setup() throws Exception {
        JmsActivation activation = this.pool.getActivation();
        JmsActivationSpec spec = activation.getActivationSpec();
        this.dlqHandler = activation.getDLQHandler();
        Connection connection = activation.getConnection();
        if (connection instanceof XAConnection && activation.isDeliveryTransacted()) {
            this.xaSession = ((XAConnection)connection).createXASession();
            this.session = this.xaSession.getSession();
        } else {
            this.transacted = spec.isSessionTransacted();
            this.acknowledge = spec.getAcknowledgeModeInt();
            this.session = connection.createSession(this.transacted, this.acknowledge);
        }
        MessageEndpointFactory endpointFactory = activation.getMessageEndpointFactory();
        XAResource xaResource = null;
        if (activation.isDeliveryTransacted() && this.xaSession != null) {
            xaResource = this.xaSession.getXAResource();
        }
        this.endpoint = endpointFactory.createEndpoint(xaResource);
        this.session.setMessageListener((MessageListener)this);
    }

    public void teardown() {
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing endpoint " + this.endpoint), t);
        }
        try {
            if (this.xaSession != null) {
                this.xaSession.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing xaSession " + this.xaSession), t);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing session " + this.session), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block7: {
            try {
                this.endpoint.beforeDelivery(JmsActivation.ONMESSAGE);
                try {
                    if (this.dlqHandler == null || !this.dlqHandler.handleRedeliveredMessage(message)) {
                        MessageListener listener = (MessageListener)this.endpoint;
                        listener.onMessage(message);
                    }
                }
                finally {
                    this.endpoint.afterDelivery();
                    if (this.dlqHandler != null) {
                        this.dlqHandler.messageDelivered(message);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)("Unexpected error delivering message " + message), t);
                if (this.txnStrategy == null) break block7;
                this.txnStrategy.error();
            }
        }
    }

    public Session getSession() throws JMSException {
        return this.session;
    }

    public void start() throws JMSException {
        JmsActivation activation = this.pool.getActivation();
        WorkManager workManager = activation.getWorkManager();
        try {
            workManager.scheduleWork((Work)this, 0L, null, (WorkListener)this);
        }
        catch (WorkException e) {
            log.error((Object)"Unable to schedule work", (Throwable)e);
            throw new JMSException("Unable to schedule work: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.txnStrategy = this.createTransactionDemarcation();
        }
        catch (Throwable t) {
            log.error((Object)"Error creating transaction demarcation. Cannot continue.");
            return;
        }
        try {
            this.session.run();
        }
        catch (Throwable t) {
            if (this.txnStrategy != null) {
                this.txnStrategy.error();
            }
        }
        finally {
            if (this.txnStrategy != null) {
                this.txnStrategy.end();
            }
            this.txnStrategy = null;
        }
    }

    private TransactionDemarcationStrategy createTransactionDemarcation() {
        return new DemarcationStrategyFactory().getStrategy();
    }

    public void release() {
    }

    public void workAccepted(WorkEvent e) {
    }

    public void workCompleted(WorkEvent e) {
        this.pool.returnServerSession(this);
    }

    public void workRejected(WorkEvent e) {
        this.pool.returnServerSession(this);
    }

    public void workStarted(WorkEvent e) {
    }

    private class XATransactionDemarcationStrategy
    implements TransactionDemarcationStrategy {
        boolean trace = JmsServerSession.access$100().isTraceEnabled();
        Transaction trans = null;
        TransactionManager tm;

        public XATransactionDemarcationStrategy() throws Throwable {
            this.tm = JmsServerSession.this.pool.getActivation().getTransactionManager();
            int timeout = JmsServerSession.this.pool.getActivation().getActivationSpec().getTransactionTimeout();
            if (timeout > 0) {
                log.trace((Object)("Setting transactionTimeout for JMSSessionPool to " + timeout));
                this.tm.setTransactionTimeout(timeout);
            }
            this.tm.begin();
            try {
                this.trans = this.tm.getTransaction();
                if (this.trace) {
                    log.trace((Object)(JmsServerSession.this + " using tx=" + this.trans));
                }
                if (JmsServerSession.this.xaSession != null) {
                    XAResource res = JmsServerSession.this.xaSession.getXAResource();
                    if (!this.trans.enlistResource(res)) {
                        throw new JMSException("could not enlist resource");
                    }
                    if (this.trace) {
                        log.trace((Object)(JmsServerSession.this + " XAResource '" + res + "' enlisted."));
                    }
                }
            }
            catch (Throwable t) {
                try {
                    this.tm.rollback();
                }
                catch (Throwable ignored) {
                    log.trace((Object)(JmsServerSession.this + " ignored error rolling back after failed enlist"), ignored);
                }
                throw t;
            }
        }

        public void error() {
            try {
                if (this.trace) {
                    log.trace((Object)(JmsServerSession.this + " using TM to mark TX for rollback tx=" + this.trans));
                }
                this.trans.setRollbackOnly();
            }
            catch (Throwable t) {
                log.error((Object)(JmsServerSession.this + " failed to set rollback only"), t);
            }
        }

        public void end() {
            try {
                Transaction currentTx = this.tm.getTransaction();
                if (!this.trans.equals(currentTx)) {
                    throw new IllegalStateException("Wrong tx association: expected " + this.trans + " was " + currentTx);
                }
                if (this.trans.getStatus() == 1) {
                    if (this.trace) {
                        log.trace((Object)(JmsServerSession.this + " rolling back JMS transaction tx=" + this.trans));
                    }
                    this.tm.rollback();
                    if (JmsServerSession.this.xaSession == null && JmsServerSession.this.pool.getActivation().isDeliveryTransacted()) {
                        JmsServerSession.this.session.rollback();
                    }
                } else if (this.trans.getStatus() == 0) {
                    if (this.trace) {
                        log.trace((Object)(JmsServerSession.this + " commiting the JMS transaction tx=" + this.trans));
                    }
                    this.tm.commit();
                    if (JmsServerSession.this.xaSession == null && JmsServerSession.this.pool.getActivation().isDeliveryTransacted()) {
                        JmsServerSession.this.session.commit();
                    }
                } else {
                    this.tm.suspend();
                    if (JmsServerSession.this.xaSession == null && JmsServerSession.this.pool.getActivation().isDeliveryTransacted()) {
                        JmsServerSession.this.session.rollback();
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)(JmsServerSession.this + " failed to commit/rollback"), t);
            }
        }
    }

    private class LocalDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private LocalDemarcationStrategy() {
        }

        public void end() {
            JmsActivationSpec spec = JmsServerSession.this.pool.getActivation().getActivationSpec();
            if (spec.isSessionTransacted() && JmsServerSession.this.session != null) {
                try {
                    JmsServerSession.this.session.commit();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to commit session transaction", (Throwable)e);
                }
            }
        }

        public void error() {
            JmsActivationSpec spec = JmsServerSession.this.pool.getActivation().getActivationSpec();
            if (spec.isSessionTransacted() && JmsServerSession.this.session != null) {
                try {
                    if (JmsServerSession.this.pool.getActivation().isDeliveryTransacted() || spec.getRedeliverUnspecified()) {
                        JmsServerSession.this.session.rollback();
                    }
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to rollback session transaction", (Throwable)e);
                }
            }
        }
    }

    private static interface TransactionDemarcationStrategy {
        public void error();

        public void end();
    }

    private class DemarcationStrategyFactory {
        private DemarcationStrategyFactory() {
        }

        TransactionDemarcationStrategy getStrategy() {
            XATransactionDemarcationStrategy current = null;
            JmsActivationSpec spec = JmsServerSession.this.pool.getActivation().getActivationSpec();
            JmsActivation activation = JmsServerSession.this.pool.getActivation();
            if (activation.isDeliveryTransacted() && JmsServerSession.this.xaSession != null) {
                try {
                    current = new XATransactionDemarcationStrategy();
                }
                catch (Throwable t) {
                    log.error((Object)(this + " error creating transaction demarcation "), t);
                }
            } else {
                return new LocalDemarcationStrategy();
            }
            return current;
        }
    }
}

