/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
import org.jboss.resource.adapter.jms.inflow.JmsServerSession;

public class JmsServerSessionPool
implements ServerSessionPool {
    private static final Logger log = Logger.getLogger(JmsServerSessionPool.class);
    JmsActivation activation;
    ConnectionConsumer consumer;
    ArrayList serverSessions = new ArrayList();
    boolean stopped = false;
    int sessionCount = 0;

    public JmsServerSessionPool(JmsActivation activation) {
        this.activation = activation;
    }

    public JmsActivation getActivation() {
        return this.activation;
    }

    public void start() throws Exception {
        this.setupSessions();
        this.setupConsumer();
    }

    public void stop() {
        this.teardownConsumer();
        this.teardownSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerSession getServerSession() throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"getServerSession");
        }
        ServerSession result = null;
        try {
            ArrayList arrayList = this.serverSessions;
            synchronized (arrayList) {
                while (true) {
                    int sessionsSize = this.serverSessions.size();
                    if (this.stopped) {
                        throw new Exception("Cannot get a server session after the pool is stopped");
                    }
                    if (sessionsSize > 0) {
                        result = (ServerSession)this.serverSessions.remove(sessionsSize - 1);
                        break;
                    }
                    try {
                        this.serverSessions.wait();
                    }
                    catch (InterruptedException ignored) {}
                }
            }
        }
        catch (Throwable t) {
            throw new JMSException("Unable to get a server session " + t);
        }
        if (trace) {
            log.trace((Object)("Returning server session " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnServerSession(JmsServerSession session) {
        ArrayList arrayList = this.serverSessions;
        synchronized (arrayList) {
            if (this.stopped) {
                session.teardown();
                --this.sessionCount;
            } else {
                this.serverSessions.add(session);
            }
            this.serverSessions.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupSessions() throws Exception {
        JmsActivationSpec spec = this.activation.getActivationSpec();
        ArrayList clonedSessions = null;
        ArrayList arrayList = this.serverSessions;
        synchronized (arrayList) {
            for (int i = 0; i < spec.getMaxSessionInt(); ++i) {
                JmsServerSession session = new JmsServerSession(this);
                this.serverSessions.add(session);
            }
            this.sessionCount = this.serverSessions.size();
            clonedSessions = (ArrayList)this.serverSessions.clone();
        }
        for (int i = 0; i < clonedSessions.size(); ++i) {
            JmsServerSession session = (JmsServerSession)clonedSessions.get(i);
            session.setup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardownSessions() {
        ArrayList arrayList = this.serverSessions;
        synchronized (arrayList) {
            this.stopped = true;
            this.serverSessions.notifyAll();
            for (int i = 0; i < this.serverSessions.size(); ++i) {
                JmsServerSession session = (JmsServerSession)this.serverSessions.get(i);
                session.teardown();
                --this.sessionCount;
            }
            this.serverSessions.clear();
            if (this.activation.getActivationSpec().isForceClearOnShutdown()) {
                int attempts = 0;
                int forceClearAttempts = this.activation.getActivationSpec().getForceClearAttempts();
                long forceClearInterval = this.activation.getActivationSpec().getForceClearOnShutdownInterval();
                log.trace((Object)(this + " force clear behavior in effect. Waiting for " + forceClearInterval + " milliseconds for " + forceClearAttempts + " attempts."));
                while (this.sessionCount > 0 && attempts < forceClearAttempts) {
                    try {
                        int currentSessions = this.sessionCount;
                        this.serverSessions.wait(forceClearInterval);
                        if (this.sessionCount != currentSessions) continue;
                        log.trace((Object)(this + " clear attempt failed " + ++attempts));
                    }
                    catch (InterruptedException ignore) {}
                }
            } else {
                while (this.sessionCount > 0) {
                    try {
                        this.serverSessions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected void setupConsumer() throws Exception {
        Connection connection = this.activation.getConnection();
        JmsActivationSpec spec = this.activation.getActivationSpec();
        String selector = spec.getMessageSelector();
        int maxMessages = spec.getMaxMessagesInt();
        if (spec.isTopic()) {
            Topic topic = (Topic)this.activation.getDestination();
            String subscriptionName = spec.getSubscriptionName();
            this.consumer = spec.isDurable() ? connection.createDurableConnectionConsumer(topic, subscriptionName, selector, (ServerSessionPool)this, maxMessages) : connection.createConnectionConsumer((Destination)topic, selector, (ServerSessionPool)this, maxMessages);
        } else {
            Queue queue = (Queue)this.activation.getDestination();
            this.consumer = connection.createConnectionConsumer((Destination)queue, selector, (ServerSessionPool)this, maxMessages);
        }
        log.debug((Object)("Created consumer " + this.consumer));
    }

    protected void teardownConsumer() {
        try {
            if (this.consumer != null) {
                log.debug((Object)("Closing the " + this.consumer));
                this.consumer.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error closing the consumer " + this.consumer), t);
        }
    }
}

