/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.mail.inflow;

import java.util.concurrent.PriorityBlockingQueue;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.mail.inflow.MailActivation;

public class NewMsgsWorker
implements Work,
WorkListener {
    private static Logger log = Logger.getLogger(NewMsgsWorker.class);
    private boolean released;
    private WorkManager mgr;
    private PriorityBlockingQueue pollQueue;
    private boolean trace;

    public NewMsgsWorker(WorkManager mgr) {
        this.mgr = mgr;
        this.pollQueue = new PriorityBlockingQueue(1024);
        this.trace = log.isTraceEnabled();
    }

    public void watch(MailActivation activation) throws InterruptedException {
        long now = System.currentTimeMillis();
        activation.updateNextNewMsgCheckTime(now);
        this.pollQueue.put(activation);
    }

    public void release() {
        this.released = true;
        if (this.trace) {
            log.trace((Object)"released");
        }
    }

    public void run() {
        if (this.trace) {
            log.trace((Object)"Begin run");
        }
        while (!this.released) {
            try {
                MailActivation ma = (MailActivation)this.pollQueue.take();
                long now = System.currentTimeMillis();
                long nextTime = ma.getNextNewMsgCheckTime();
                long sleepMS = nextTime - now;
                Thread.sleep(sleepMS);
                if (this.released) break;
                if (ma.isReleased()) continue;
                this.mgr.scheduleWork((Work)ma, Long.MAX_VALUE, null, (WorkListener)this);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Interrupted waiting for new msg check", (Throwable)e);
            }
            catch (WorkException e) {
                log.warn((Object)"Failed to schedule new msg check", (Throwable)e);
            }
        }
        if (this.trace) {
            log.trace((Object)"End run");
        }
    }

    public void workAccepted(WorkEvent e) {
        if (this.trace) {
            log.trace((Object)("workAccepted, e=" + e));
        }
    }

    public void workRejected(WorkEvent e) {
        if (this.trace) {
            log.trace((Object)("workRejected, e=" + e));
        }
    }

    public void workStarted(WorkEvent e) {
        if (this.trace) {
            log.trace((Object)("workStarted, e=" + e));
        }
    }

    public void workCompleted(WorkEvent e) {
        if (this.trace) {
            log.trace((Object)("workCompleted, e=" + e));
        }
        MailActivation activation = (MailActivation)e.getWork();
        try {
            this.watch(activation);
        }
        catch (InterruptedException ex) {
            log.warn((Object)"Failed to reschedule new msg check", (Throwable)ex);
        }
    }
}

