/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.lang.constant.Constable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ConnectionListenerFactory;
import org.jboss.resource.connectionmanager.InternalManagedConnectionPool;
import org.jboss.resource.connectionmanager.JBossManagedConnectionPoolMBean;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.resource.connectionmanager.PreFillPoolSupport;
import org.jboss.resource.connectionmanager.RetryableResourceException;
import org.jboss.resource.statistic.JBossConnectionStatistics;
import org.jboss.resource.statistic.JBossStatistics;
import org.jboss.resource.statistic.StatisticsReporter;
import org.jboss.resource.statistic.formatter.StatisticsFormatter;
import org.jboss.resource.statistic.pool.JBossDefaultSubPoolStatisticFormatter;
import org.jboss.resource.statistic.pool.JBossManagedConnectionPoolStatistics;
import org.jboss.resource.statistic.pool.JBossSubPoolStatistics;
import org.jboss.resource.statistic.pool.ManagedConnectionPoolStatistics;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionLocal;

@ManagementObject(isRuntime=true, properties=ManagementProperties.EXPLICIT)
public class JBossManagedConnectionPool
extends ServiceMBeanSupport
implements JBossManagedConnectionPoolMBean,
NotificationListener {
    static Logger log = Logger.getLogger(JBossManagedConnectionPool.class);
    private ObjectName managedConnectionFactoryName;
    private String criteria;
    private ManagedConnectionPool poolingStrategy;
    private final InternalManagedConnectionPool.PoolParams poolParams = new InternalManagedConnectionPool.PoolParams();
    private boolean noTxSeparatePools;
    private String statisticsFormatter;
    private String poolJndiName;

    @Override
    @ManagementOperation(description="Obtain a formatted statistics report", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="formatClassName", description="The StatisticsFormatter class name")})
    public Object listFormattedSubPoolStatistics(String formatClassName) {
        JBossStatistics stats = (JBossStatistics)this.listStatistics();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        StatisticsFormatter formatter = null;
        try {
            Class<?> clazz = cl.loadClass(formatClassName);
            formatter = (StatisticsFormatter)clazz.newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("warn: statistics formatter not found, setting to " + this.statisticsFormatter));
            formatter = new JBossDefaultSubPoolStatisticFormatter();
        }
        return formatter.formatStatistics(stats);
    }

    @Override
    @ManagementOperation(description="Obtain a formatted statistics report", impact=ManagedOperation.Impact.ReadOnly)
    public Object listFormattedSubPoolStatistics() {
        Object formatted = this.listFormattedSubPoolStatistics(this.statisticsFormatter);
        return formatted;
    }

    @Override
    @ManagementOperation(description="Obtain a statistics report", impact=ManagedOperation.Impact.ReadOnly)
    public Object listStatistics() {
        ManagedConnectionPoolStatistics stats = null;
        if (this.poolingStrategy instanceof StatisticsReporter) {
            StatisticsReporter reporter = (StatisticsReporter)((Object)this.poolingStrategy);
            stats = (ManagedConnectionPoolStatistics)reporter.listStatistics();
            stats.setCriteria(this.getCriteria());
            stats.setName(this.getManagedConnectionFactoryName().toString());
        }
        return stats;
    }

    @Override
    public Object listUnderlyingNativeConnectionStatistics() {
        return this.poolingStrategy.listUnderlyingNativeConnectionStatistics();
    }

    @Override
    public ManagedConnectionPool getManagedConnectionPool() {
        return this.poolingStrategy;
    }

    @Override
    public ObjectName getManagedConnectionFactoryName() {
        return this.managedConnectionFactoryName;
    }

    @Override
    public void setManagedConnectionFactoryName(ObjectName newManagedConnectionFactoryName) {
        this.managedConnectionFactoryName = newManagedConnectionFactoryName;
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="number of available connection")
    public long getAvailableConnectionCount() {
        return this.poolingStrategy == null ? 0L : this.poolingStrategy.getAvailableConnectionCount();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="number of maximum connections in use")
    public long getMaxConnectionsInUseCount() {
        return this.poolingStrategy == null ? 0L : (long)this.poolingStrategy.getMaxConnectionsInUseCount();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="number of connections currently in use")
    public long getInUseConnectionCount() {
        return this.poolingStrategy == null ? 0L : (long)this.poolingStrategy.getInUseConnectionCount();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getMinSize() {
        return this.poolParams.minSize;
    }

    @Override
    public void setMinSize(int newMinSize) {
        this.poolParams.minSize = newMinSize;
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getMaxSize() {
        return this.poolParams.maxSize;
    }

    @Override
    public void setMaxSize(int newMaxSize) {
        this.poolParams.maxSize = newMaxSize;
    }

    @Override
    public int getBlockingTimeoutMillis() {
        return this.poolParams.blockingTimeout;
    }

    @Override
    public void setBlockingTimeoutMillis(int newBlockingTimeout) {
        this.poolParams.blockingTimeout = newBlockingTimeout;
    }

    @Override
    public long getIdleTimeoutMinutes() {
        return this.poolParams.idleTimeout / 60000L;
    }

    @Override
    public void setIdleTimeoutMinutes(long newIdleTimeoutMinutes) {
        this.poolParams.idleTimeout = newIdleTimeoutMinutes * 1000L * 60L;
    }

    public long getIdleTimeout() {
        return this.poolParams.idleTimeout;
    }

    public void setIdleTimeout(long newIdleTimeout) {
        this.poolParams.idleTimeout = newIdleTimeout;
    }

    @Override
    public String getCriteria() {
        return this.criteria;
    }

    @Override
    public void setCriteria(String newCriteria) {
        this.criteria = newCriteria;
    }

    @Override
    public boolean getNoTxSeparatePools() {
        return this.noTxSeparatePools;
    }

    @Override
    public void setNoTxSeparatePools(boolean value) {
        this.noTxSeparatePools = value;
    }

    @Override
    public boolean getPreFill() {
        return this.poolParams.prefill;
    }

    @Override
    public void setPreFill(boolean prefill) {
        this.poolParams.prefill = prefill;
    }

    @Override
    public void setStrictMin(boolean strictMin) {
        this.poolParams.stictMin = strictMin;
    }

    @Override
    public boolean getStrictMin() {
        return this.poolParams.stictMin;
    }

    @Override
    public boolean getUseFastFail() {
        return this.poolParams.useFastFail;
    }

    @Override
    public void setUseFastFail(boolean useFastFail) {
        this.poolParams.useFastFail = useFastFail;
    }

    @Override
    @ManagementOperation(description="Flush the connections in the pool", impact=ManagedOperation.Impact.WriteOnly)
    public void flush() {
        PreFillPoolSupport pfs;
        if (this.poolingStrategy == null) {
            throw new IllegalStateException("The connection pool is not started");
        }
        this.poolingStrategy.flush();
        if (this.poolingStrategy instanceof PreFillPoolSupport && (pfs = (PreFillPoolSupport)((Object)this.poolingStrategy)).shouldPreFill()) {
            pfs.prefill(this.noTxSeparatePools);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean internalTestConnection(Subject subject) {
        boolean result = false;
        ConnectionListener cl = null;
        if (this.getAvailableConnectionCount() > 0L) {
            cl = this.poolingStrategy.getConnection(null, subject, null);
            result = true;
        }
        if (cl == null) return result;
        try {
            this.poolingStrategy.returnConnection(cl, false);
            return result;
        }
        catch (ResourceException ire) {}
        return result;
        catch (Exception ignored) {
            if (cl == null) return result;
            try {
                this.poolingStrategy.returnConnection(cl, false);
                return result;
            }
            catch (ResourceException ire) {}
            return result;
            catch (Throwable throwable) {
                if (cl == null) throw throwable;
                try {
                    this.poolingStrategy.returnConnection(cl, false);
                    throw throwable;
                }
                catch (ResourceException ire) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    @Override
    @ManagementOperation(description="Test if a connection can be obtained", impact=ManagedOperation.Impact.WriteOnly)
    public boolean testConnection() {
        BasePool basePool;
        boolean result = false;
        Object cl = null;
        if (this.poolingStrategy instanceof BasePool && (basePool = (BasePool)this.poolingStrategy).clf instanceof BaseConnectionManager2) {
            try {
                BaseConnectionManager2 baseConnectionMgr = (BaseConnectionManager2)basePool.clf;
                Subject subject = baseConnectionMgr.getSubjectFactory().createSubject(baseConnectionMgr.getSecurityDomainJndiName());
                result = this.internalTestConnection(subject);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (!result) {
            result = this.internalTestConnection(null);
        }
        return result;
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getConnectionCount() {
        return this.poolingStrategy == null ? 0 : this.poolingStrategy.getConnectionCount();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getConnectionCreatedCount() {
        return this.poolingStrategy == null ? 0 : this.poolingStrategy.getConnectionCreatedCount();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getConnectionDestroyedCount() {
        return this.poolingStrategy == null ? 0 : this.poolingStrategy.getConnectionDestroyedCount();
    }

    public String getName() {
        return "JBossManagedConnectionPool";
    }

    @Override
    public String getStatisticsFormatter() {
        return this.statisticsFormatter;
    }

    @Override
    public void setStatisticsFormatter(String statisticsFormatter) {
        this.statisticsFormatter = statisticsFormatter;
    }

    @Override
    @ManagementObjectID(type="DataSource")
    @ManagementProperty(use={ViewUse.RUNTIME})
    public String getPoolJndiName() {
        return this.poolJndiName;
    }

    @Override
    public void setPoolJndiName(String poolName) {
        this.poolJndiName = poolName;
    }

    @Override
    public long getBackGroundValidationMillis() {
        return this.poolParams.backgroundInterval;
    }

    @Override
    public void setBackGroundValidationMillis(long backgroundValidationInterval) {
        this.poolParams.backgroundInterval = backgroundValidationInterval;
    }

    protected void startService() throws Exception {
        ManagedConnectionFactory mcf = null;
        if (this.managedConnectionFactoryName == null) {
            throw new DeploymentException("ManagedConnectionFactory is not set.");
        }
        try {
            mcf = (ManagedConnectionFactory)this.server.getAttribute(this.managedConnectionFactoryName, "McfInstance");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
        }
        this.getServer().addNotificationListener(this.managedConnectionFactoryName, this, new NotificationFilter(){
            private static final long serialVersionUID = -9211456539783257343L;

            @Override
            public boolean isNotificationEnabled(Notification n) {
                return "jboss.mcfattributechangednotification".equals(n.getType()) && JBossManagedConnectionPool.this.managedConnectionFactoryName.equals(n.getSource());
            }
        }, null);
        if ("ByContainerAndApplication".equals(this.criteria)) {
            this.poolingStrategy = new PoolBySubjectAndCri(mcf, this.poolParams, this.noTxSeparatePools, this, log);
        } else if ("ByContainer".equals(this.criteria)) {
            this.poolingStrategy = new PoolBySubject(mcf, this.poolParams, this.noTxSeparatePools, this, log);
        } else if ("ByApplication".equals(this.criteria)) {
            this.poolingStrategy = new PoolByCri(mcf, this.poolParams, this.noTxSeparatePools, this, log);
        } else if ("ByNothing".equals(this.criteria)) {
            this.poolingStrategy = new OnePool(mcf, this.poolParams, this.noTxSeparatePools, this, log);
        } else {
            throw new DeploymentException("Unknown pooling criteria: " + this.criteria);
        }
    }

    protected void stopService() throws Exception {
        if (this.poolingStrategy != null) {
            this.poolingStrategy.shutdown();
        }
        this.getServer().removeNotificationListener(this.managedConnectionFactoryName, this);
        this.poolingStrategy = null;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        log.trace((Object)("Flushing pool due to notification from ManagedConnectionFactory" + notification));
        this.flush();
    }

    ManagedConnectionPool getPoolingStrategy() {
        return this.poolingStrategy;
    }

    private static class SubjectActions
    implements PrivilegedAction {
        Subject subject;
        Subject other;

        SubjectActions(Subject subject, Subject other) {
            this.subject = subject;
            this.other = other;
        }

        public Object run() {
            Constable value = null;
            value = this.other == null ? (Constable)Integer.valueOf(this.subject.hashCode()) : (Constable)Boolean.valueOf(this.subject.equals(this.other));
            return value;
        }

        static int hashCode(Subject subject) {
            SubjectActions action = new SubjectActions(subject, null);
            return (Integer)AccessController.doPrivileged(action);
        }

        static boolean equals(Subject subject, Subject other) {
            SubjectActions action = new SubjectActions(subject, other);
            return (Boolean)AccessController.doPrivileged(action);
        }
    }

    public static class OnePool
    extends BasePool {
        public OnePool(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, Logger log) {
            super(mcf, poolParams, noTxSeparatePools, null, log);
        }

        public OnePool(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, JBossManagedConnectionPool jmcp, Logger log) {
            super(mcf, poolParams, noTxSeparatePools, jmcp, log);
        }

        @Override
        protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx) {
            if (separateNoTx) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public void prefill(Subject sub) {
            log.debug((Object)("Attempting to prefill pool" + this.getClass()));
            try {
                this.getSubPool(this.getKey(null, null, false), null, null);
            }
            catch (ResourceException e) {
                log.error((Object)("Prefill failed for pool instance " + this.getClass()), (Throwable)e);
            }
        }

        @Override
        public void emptySubPool(InternalManagedConnectionPool pool) {
        }
    }

    private static class CriKey {
        private static final Object NOCRI = new Object();
        private final Object cri;
        private boolean separateNoTx;
        private int hashCode = Integer.MAX_VALUE;

        CriKey(ConnectionRequestInfo cri, boolean separateNoTx) {
            this.cri = cri == null ? NOCRI : cri;
            this.separateNoTx = separateNoTx;
        }

        public int hashCode() {
            if (this.hashCode == Integer.MAX_VALUE) {
                this.hashCode = this.cri.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof CriKey)) {
                return false;
            }
            CriKey other = (CriKey)obj;
            return this.cri.equals(other.cri) && this.separateNoTx == other.separateNoTx;
        }
    }

    public static class PoolByCri
    extends BasePool {
        public PoolByCri(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, JBossManagedConnectionPool jmcp, Logger log) {
            super(mcf, poolParams, noTxSeparatePools, jmcp, log);
        }

        @Override
        protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx) {
            return new CriKey(cri, separateNoTx);
        }

        @Override
        public void prefill() {
            this.prefill(null, null, false);
        }

        @Override
        public void prefill(boolean noTxSeperatePool) {
            this.prefill(null, null, noTxSeperatePool);
        }

        public void prefill(Subject subject, ConnectionRequestInfo cri) {
            this.prefill(subject, cri, false);
        }

        @Override
        public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool) {
            if (this.getPreFill()) {
                log.warn((Object)("Prefill pool option was selected for pool with JNDI name " + this.getPoolName() + " that does not support this feature."));
                log.warn((Object)"Please verify your *-ds.xml file that corresponds with this resource and either remove the <prefill>true|false</prefill element or explicitly set this value to false.");
            }
        }
    }

    private static class SubjectKey {
        private static final Subject NOSUBJECT = new Subject();
        private final Subject subject;
        private boolean separateNoTx;
        private int hashCode = Integer.MAX_VALUE;

        SubjectKey(Subject subject, boolean separateNoTx) {
            this.subject = subject == null ? NOSUBJECT : subject;
            this.separateNoTx = separateNoTx;
        }

        public int hashCode() {
            if (this.hashCode == Integer.MAX_VALUE) {
                this.hashCode = SubjectActions.hashCode(this.subject);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof SubjectKey)) {
                return false;
            }
            SubjectKey other = (SubjectKey)obj;
            return SubjectActions.equals(this.subject, other.subject) && this.separateNoTx == other.separateNoTx;
        }
    }

    public static class PoolBySubject
    extends BasePool {
        public PoolBySubject(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, JBossManagedConnectionPool jmcp, Logger log) {
            super(mcf, poolParams, noTxSeparatePools, jmcp, log);
        }

        @Override
        protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx) {
            return new SubjectKey(subject, separateNoTx);
        }

        @Override
        public void prefill() {
            this.prefill(null, null, false);
        }

        @Override
        public void prefill(boolean noTxSeperatePool) {
            this.prefill(null, null, noTxSeperatePool);
        }

        public void prefill(Subject subject, ConnectionRequestInfo cri) {
            this.prefill(subject, cri, false);
        }

        @Override
        public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool) {
            if (this.getPreFill()) {
                log.warn((Object)("Prefill pool option was selected for pool with JNDI name " + this.getPoolName() + " that does not support this feature."));
                log.warn((Object)"Please verify your *-ds.xml file that corresponds with this resource and either remove the <prefill>true|false</prefill element or explicitly set this value to false.");
            }
        }
    }

    private static class SubjectCriKey {
        private static final Subject NOSUBJECT = new Subject();
        private static final Object NOCRI = new Object();
        private final Subject subject;
        private final Object cri;
        private int hashCode = Integer.MAX_VALUE;
        private boolean separateNoTx;

        SubjectCriKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx) {
            this.subject = subject == null ? NOSUBJECT : subject;
            this.cri = cri == null ? NOCRI : cri;
            this.separateNoTx = separateNoTx;
        }

        public int hashCode() {
            if (this.hashCode == Integer.MAX_VALUE) {
                this.hashCode = SubjectActions.hashCode(this.subject) ^ this.cri.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof SubjectCriKey)) {
                return false;
            }
            SubjectCriKey other = (SubjectCriKey)obj;
            return SubjectActions.equals(this.subject, other.subject) && this.cri.equals(other.cri) && this.separateNoTx == other.separateNoTx;
        }
    }

    public static class PoolBySubjectAndCri
    extends BasePool {
        public PoolBySubjectAndCri(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, JBossManagedConnectionPool jmcp, Logger log) {
            super(mcf, poolParams, noTxSeparatePools, jmcp, log);
        }

        @Override
        protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx) throws ResourceException {
            return new SubjectCriKey(subject, cri, separateNoTx);
        }

        @Override
        public void prefill() {
            this.prefill(null, null, false);
        }

        @Override
        public void prefill(boolean noTxSeperatePool) {
            this.prefill(null, null, noTxSeperatePool);
        }

        public void prefill(Subject subject, ConnectionRequestInfo cri) {
            this.prefill(subject, cri, false);
        }

        @Override
        public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool) {
            if (this.getPreFill()) {
                log.warn((Object)("Prefill pool option was selected for pool with JNDI name " + this.getPoolName() + " that does not support this feature."));
                log.warn((Object)"Please verify your *-ds.xml file that corresponds with this resource and either remove the <prefill>true|false</prefill element or explicitly set this value to false.");
            }
        }
    }

    public static abstract class BasePool
    implements ManagedConnectionPool,
    StatisticsReporter,
    PreFillPoolSupport {
        private final ConcurrentMap<Object, SubPoolContext> subPools = new ConcurrentHashMap<Object, SubPoolContext>();
        private final ManagedConnectionFactory mcf;
        private ConnectionListenerFactory clf;
        private final InternalManagedConnectionPool.PoolParams poolParams;
        private boolean noTxSeparatePools;
        private String poolName;
        private final JBossManagedConnectionPool jmcp;
        private final Logger log;
        private boolean traceEnabled = false;

        public BasePool(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, JBossManagedConnectionPool jmcp, Logger log) {
            this.mcf = mcf;
            this.poolParams = poolParams;
            this.noTxSeparatePools = noTxSeparatePools;
            this.jmcp = jmcp;
            this.log = log;
            this.traceEnabled = log.isTraceEnabled();
        }

        protected abstract Object getKey(Subject var1, ConnectionRequestInfo var2, boolean var3) throws ResourceException;

        @Override
        public ManagedConnectionFactory getManagedConnectionFactory() {
            return this.mcf;
        }

        @Override
        public void setConnectionListenerFactory(ConnectionListenerFactory clf) {
            this.clf = clf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConnectionListener getConnection(Transaction trackByTransaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
            ConnectionListener cl;
            boolean separateNoTx = false;
            if (this.noTxSeparatePools) {
                separateNoTx = this.clf.isTransactional();
            }
            Object key = this.getKey(subject, cri, separateNoTx);
            SubPoolContext subPool = this.getSubPool(key, subject, cri);
            InternalManagedConnectionPool mcp = subPool.getSubPool();
            TransactionLocal trackByTx = subPool.getTrackByTx();
            if (trackByTransaction == null || trackByTx == null) {
                try {
                    ConnectionListener cl2 = mcp.getConnection(subject, cri);
                    if (this.traceEnabled) {
                        this.dump("Got connection from pool " + cl2);
                    }
                    return cl2;
                }
                catch (RetryableResourceException rre) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Got a RetryableResourceException - trying to reinitialize the pool");
                    }
                    if (!(mcp = (subPool = this.getSubPool(key, subject, cri)).getSubPool()).isRunning()) {
                        mcp.initialize();
                    }
                    ConnectionListener cl3 = mcp.getConnection(subject, cri);
                    if (this.traceEnabled) {
                        this.dump("Got connection from pool (retried) " + cl3);
                    }
                    return cl3;
                }
            }
            try {
                trackByTx.lock(trackByTransaction);
            }
            catch (Throwable t) {
                JBossResourceException.rethrowAsResourceException("Unable to get connection from the pool for tx=" + trackByTransaction, t);
            }
            try {
                cl = (ConnectionListener)trackByTx.get(trackByTransaction);
                if (cl != null) {
                    if (this.traceEnabled) {
                        this.dump("Previous connection tracked by transaction " + cl + " tx=" + trackByTransaction);
                    }
                    ConnectionListener cl3 = cl;
                    return cl3;
                }
            }
            finally {
                trackByTx.unlock(trackByTransaction);
            }
            cl = mcp.getConnection(subject, cri);
            if (this.traceEnabled) {
                this.dump("Got connection from pool tracked by transaction " + cl + " tx=" + trackByTransaction);
            }
            try {
                trackByTx.lock(trackByTransaction);
            }
            catch (Throwable t) {
                mcp.returnConnection(cl, false);
                if (this.traceEnabled) {
                    this.dump("Had to return connection tracked by transaction " + cl + " tx=" + trackByTransaction + " error=" + t.getMessage());
                }
                JBossResourceException.rethrowAsResourceException("Unable to get connection from the pool for tx=" + trackByTransaction, t);
            }
            try {
                ConnectionListener other = (ConnectionListener)trackByTx.get(trackByTransaction);
                if (other != null) {
                    mcp.returnConnection(cl, false);
                    if (this.traceEnabled) {
                        this.dump("Another thread already got a connection tracked by transaction " + other + " tx=" + trackByTransaction);
                    }
                    ConnectionListener connectionListener = other;
                    return connectionListener;
                }
                cl.setTrackByTx(true);
                trackByTx.set((Object)cl);
                if (this.traceEnabled) {
                    this.dump("Using connection from pool tracked by transaction " + cl + " tx=" + trackByTransaction);
                }
                ConnectionListener connectionListener = cl;
                return connectionListener;
            }
            finally {
                trackByTx.unlock(trackByTransaction);
            }
        }

        @Override
        public void returnConnection(ConnectionListener cl, boolean kill) throws ResourceException {
            cl.setTrackByTx(false);
            InternalManagedConnectionPool mcp = (InternalManagedConnectionPool)cl.getContext();
            mcp.returnConnection(cl, kill);
            if (this.traceEnabled) {
                this.dump("Returning connection to pool " + cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInUseConnectionCount() {
            int count = 0;
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    count += subPool.getSubPool().getConnectionInUseCount();
                }
            }
            return count;
        }

        public boolean getPreFill() {
            return this.poolParams.prefill;
        }

        @Override
        public boolean shouldPreFill() {
            return this.getPreFill();
        }

        @Override
        public void prefill() {
            this.prefill(null, null, false);
        }

        @Override
        public void prefill(boolean noTxSeperatePool) {
            this.prefill(null, null, noTxSeperatePool);
        }

        @Override
        public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool) {
            if (this.getPreFill()) {
                this.log.debug((Object)("Attempting to prefill pool for pool with jndi name" + this.poolName));
                try {
                    this.getSubPool(this.getKey(subject, cri, this.noTxSeparatePools), subject, cri);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Unable to prefill pool with jndi name" + this.getPoolName()), t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getConnectionCount() {
            int count = 0;
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    count += subPool.getSubPool().getConnectionCount();
                }
            }
            return count;
        }

        public String getPoolName() {
            return this.poolName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getConnectionCreatedCount() {
            int count = 0;
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    count += subPool.getSubPool().getConnectionCreatedCount();
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getConnectionDestroyedCount() {
            int count = 0;
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    count += subPool.getSubPool().getConnectionDestroyedCount();
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getAvailableConnectionCount() {
            long count = 0L;
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                if (this.subPools.size() == 0) {
                    return this.poolParams.maxSize;
                }
                for (SubPoolContext subPool : this.subPools.values()) {
                    count += subPool.getSubPool().getAvailableConnections();
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getMaxConnectionsInUseCount() {
            int count = 0;
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    count += subPool.getSubPool().getMaxConnectionsInUseCount();
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    subPool.getSubPool().shutdown();
                }
                this.subPools.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    subPool.getSubPool().shutdown();
                }
                this.subPools.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void emptySubPool(InternalManagedConnectionPool pool) {
            if (pool != null) {
                ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
                synchronized (concurrentMap) {
                    Iterator i = this.subPools.values().iterator();
                    while (i.hasNext()) {
                        SubPoolContext subPoolContext = (SubPoolContext)i.next();
                        InternalManagedConnectionPool other = subPoolContext.getSubPool();
                        if (other != pool || !pool.isEmpty()) continue;
                        pool.shutdown();
                        i.remove();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdownWithoutClear() {
            ConcurrentMap<Object, SubPoolContext> concurrentMap = this.subPools;
            synchronized (concurrentMap) {
                for (SubPoolContext subPool : this.subPools.values()) {
                    subPool.getSubPool().shutdown();
                }
            }
        }

        protected TransactionManager getTransactionManager() {
            if (this.clf != null) {
                return this.clf.getTransactionManagerInstance();
            }
            return null;
        }

        protected SubPoolContext getSubPool(Object key, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
            SubPoolContext newSubPool;
            SubPoolContext subPool = (SubPoolContext)this.subPools.get(key);
            if (subPool == null && (subPool = this.subPools.putIfAbsent(key, newSubPool = new SubPoolContext(this.getTransactionManager(), this.mcf, this.clf, subject, cri, this.poolParams, this.jmcp, this.log))) == null) {
                subPool = newSubPool;
                subPool.initialize();
            }
            return subPool;
        }

        private void dump(String info) {
            if (this.traceEnabled) {
                StringBuffer toLog = new StringBuffer(100);
                toLog.append(info).append(" [InUse/Available/Max]: [");
                toLog.append(this.getInUseConnectionCount()).append("/");
                toLog.append(this.getAvailableConnectionCount()).append("/");
                toLog.append(this.poolParams.maxSize);
                toLog.append("]");
                this.log.trace((Object)toLog);
            }
        }

        @Override
        public JBossStatistics listStatistics() {
            JBossManagedConnectionPoolStatistics subPoolStats = new JBossManagedConnectionPoolStatistics(this.subPools.size());
            subPoolStats.setBlockingTimeout(this.poolParams.blockingTimeout);
            subPoolStats.setIdleTimeout(this.poolParams.idleTimeout);
            subPoolStats.setMax(this.poolParams.maxSize);
            subPoolStats.setMin(this.poolParams.minSize);
            subPoolStats.setPrefill(this.poolParams.prefill);
            subPoolStats.setNoTxnSeperatePool(this.noTxSeparatePools);
            Iterator iter = this.subPools.values().iterator();
            while (iter.hasNext()) {
                JBossSubPoolStatistics stat = new JBossSubPoolStatistics();
                SubPoolContext subContext = (SubPoolContext)iter.next();
                InternalManagedConnectionPool internalPool = subContext.getSubPool();
                stat.setAvailableConnections(internalPool.getAvailableConnections());
                stat.setConnectionsDestroyed(internalPool.getConnectionDestroyedCount());
                stat.setConnectionsInUse(internalPool.getConnectionInUseCount());
                stat.setMaxConnectionsInUse(internalPool.getMaxConnectionsInUseCount());
                stat.setTotalBlockTime(internalPool.getTotalBlockTime());
                stat.setAverageBlockTime(internalPool.getAverageBlockTime());
                stat.setMaxWaitTime(internalPool.getMaxWaitTime());
                stat.setTotalTimedOut(internalPool.getTimedOut());
                subPoolStats.addSubPool((JBossStatistics)stat);
            }
            return subPoolStats;
        }

        @Override
        public Object listUnderlyingNativeConnectionStatistics() {
            String statistics = "";
            block0: for (SubPoolContext subContext : this.subPools.values()) {
                InternalManagedConnectionPool internalPool = subContext.getSubPool();
                Set cels = internalPool.getConnectionListeners();
                for (ConnectionListener cl : cels) {
                    ManagedConnection mc = cl.getManagedConnection();
                    if (mc instanceof JBossConnectionStatistics) {
                        JBossConnectionStatistics stats = (JBossConnectionStatistics)mc;
                        if (!(statistics = statistics + stats.listConnectionStats()).startsWith("-1")) continue;
                        statistics = " ManagedConnetion in a Pool does not expose NativeConnectionStatistics !!!... ";
                        continue block0;
                    }
                    statistics = mc + " does not implement org.jboss.resource.statistic.JBossConnectionStatistics , <br><font color='red'>So this Operation is Not available!!!</font> ";
                    continue block0;
                }
            }
            return statistics;
        }
    }

    public static class SubPoolContext {
        private InternalManagedConnectionPool subPool;
        private TransactionLocal trackByTx;

        public SubPoolContext(TransactionManager tm, ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, InternalManagedConnectionPool.PoolParams poolParams, JBossManagedConnectionPool jmcp, Logger log) {
            this.subPool = new InternalManagedConnectionPool(mcf, clf, subject, cri, poolParams, jmcp, log);
            if (tm != null) {
                this.trackByTx = new TransactionLocal(tm);
            }
        }

        public InternalManagedConnectionPool getSubPool() {
            return this.subPool;
        }

        public TransactionLocal getTrackByTx() {
            return this.trackByTx;
        }

        public void initialize() {
            this.subPool.initialize();
        }
    }
}

