/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow.dlq;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import org.jboss.resource.adapter.jms.inflow.dlq.JBossMQDLQHandler;

public class GenericDLQHandler
extends JBossMQDLQHandler {
    protected HashMap resent = new HashMap();

    @Override
    public void messageDelivered(Message msg) {
        try {
            String id = msg.getJMSMessageID();
            if (id == null) {
                log.error((Object)("Message id is null? " + msg));
                return;
            }
            this.clearResentCounter(id);
        }
        catch (Throwable t) {
            log.warn((Object)("Unexpected error processing delivery notification " + msg), t);
        }
    }

    @Override
    protected boolean handleDelivery(Message msg) {
        boolean handled = super.handleDelivery(msg);
        if (handled) {
            return true;
        }
        try {
            if (msg.propertyExists("JMS_JBOSS_REDELIVERY_COUNT")) {
                return false;
            }
            String id = msg.getJMSMessageID();
            if (id == null) {
                log.error((Object)("Message id is null? " + msg));
                return false;
            }
            int count = 0;
            try {
                if (msg.propertyExists("JMSXDeliveryCount")) {
                    count = msg.getIntProperty("JMSXDeliveryCount") - 1;
                }
            }
            catch (JMSException ignored) {
                count = this.incrementResentCounter(id);
            }
            int max = this.maxResent;
            if (msg.propertyExists("JMS_JBOSS_REDELIVERY_LIMIT")) {
                max = msg.getIntProperty("JMS_JBOSS_REDELIVERY_LIMIT");
            }
            if (count > max) {
                this.warnDLQ(msg, count, max);
                this.clearResentCounter(id);
                return true;
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Unexpected error checking whether dlq should be used " + msg), t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int incrementResentCounter(String id) {
        ResentInfo info;
        HashMap hashMap = this.resent;
        synchronized (hashMap) {
            info = (ResentInfo)this.resent.get(id);
            if (info == null) {
                info = new ResentInfo();
                this.resent.put(id, info);
            }
        }
        return ++info.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearResentCounter(String id) {
        HashMap hashMap = this.resent;
        synchronized (hashMap) {
            this.resent.remove(id);
        }
    }

    protected static class ResentInfo {
        int count = 0;

        protected ResentInfo() {
        }
    }
}

