/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.xa.XidWrapper;
import org.jboss.resource.connectionmanager.xa.XidWrapperImpl;
import org.jboss.tm.XAResourceWrapper;

public class XAResourceWrapperImpl
implements XAResourceWrapper {
    private static final Logger log = Logger.getLogger(XAResourceWrapperImpl.class);
    private XAResource xaResource;
    private boolean pad;
    private Boolean overrideRmValue;
    private String productName;
    private String productVersion;

    public XAResourceWrapperImpl(XAResource resource) {
        this(resource, false, Boolean.FALSE, null, null);
    }

    public XAResourceWrapperImpl(XAResource resource, boolean pad) {
        this(resource, pad, Boolean.FALSE, null, null);
    }

    public XAResourceWrapperImpl(XAResource resource, boolean pad, Boolean override) {
        this(resource, pad, override, null, null);
    }

    public XAResourceWrapperImpl(XAResource resource, boolean pad, Boolean override, String productName, String productVersion) {
        this.overrideRmValue = override;
        this.pad = pad;
        this.xaResource = resource;
        this.productName = productName;
        this.productVersion = productVersion;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (this.overrideRmValue != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Executing isSameRM with override value" + this.overrideRmValue + " for XAResourceWrapper" + this));
            }
            return this.overrideRmValue;
        }
        if (resource instanceof XAResourceWrapper) {
            XAResourceWrapper other = (XAResourceWrapper)resource;
            return this.xaResource.isSameRM(other.getResource());
        }
        return this.xaResource.isSameRM(resource);
    }

    public int prepare(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        return this.xaResource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int flag) throws XAException {
        return this.xaResource.setTransactionTimeout(flag);
    }

    public void start(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.start(xid, flags);
    }

    public XAResource getResource() {
        return this.xaResource;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    private Xid convertXid(Xid xid) {
        if (xid instanceof XidWrapper) {
            return xid;
        }
        return new XidWrapperImpl(this.pad, xid);
    }

    public String toString() {
        return super.toString();
    }
}

