/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resource.deployment.ConfigProperty;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.util.Classes;

public class ConfigPropertyHandler {
    private static final Logger log = Logger.getLogger(ConfigPropertyHandler.class);
    private static Map<String, Class<?>> PRIMATIVE_TYPE_ALTERNATES = new HashMap();
    private final Object configTarget;
    private final Class configTargetType;
    private final String traceIdentifier;

    public ConfigPropertyHandler(Object configTarget, Class configTargetType) {
        this(configTarget, configTargetType, "");
    }

    public ConfigPropertyHandler(Object configTarget, Class configTargetType, String traceIdentifier) {
        this.configTarget = configTarget;
        this.configTargetType = configTargetType;
        this.traceIdentifier = traceIdentifier;
    }

    public void handle(ConfigProperty configProperty) throws Exception {
        this.handle(configProperty, true);
    }

    public void handle(ConfigProperty configProperty, boolean mustExist) throws Exception {
        String propertyName;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handling config property - " + configProperty));
        }
        if ((propertyName = configProperty.getName()) == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Null or empty attribute name " + propertyName);
        }
        Object propertyValue = configProperty.getValue();
        if (propertyValue == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not setting config property with null value " + configProperty));
            }
            return;
        }
        String setterName = this.getSetterName(propertyName);
        Method method = null;
        try {
            method = this.getMethod(setterName, configProperty.getType());
        }
        catch (NoSuchMethodException nsme) {
            String error = "The class '" + this.configTargetType + "' has no setter for config property '" + propertyName + "'";
            if (mustExist) {
                throw new IllegalArgumentException(error, nsme);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)error, (Throwable)nsme);
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.traceIdentifier + " setting property=" + propertyName + " value=" + configProperty.getValue()));
        }
        method.invoke(this.configTarget, configProperty.getValue());
    }

    public void handle(ConfigPropertyMetaData configPropertyMetaData) throws Exception {
        this.handle(configPropertyMetaData, true);
    }

    public void handle(ConfigPropertyMetaData configPropertyMetaData, boolean mustExist) throws Exception {
        String propertyName = configPropertyMetaData.getName();
        String propertyType = configPropertyMetaData.getType();
        String propertyValue = configPropertyMetaData.getValue();
        if (propertyValue == null || propertyValue.length() == 0) {
            log.debug((Object)("Not setting config property with null value " + configPropertyMetaData));
            return;
        }
        Class<?> expectedPropertyType = Classes.getPrimitiveTypeForName((String)propertyType);
        if (expectedPropertyType == null) {
            try {
                expectedPropertyType = Thread.currentThread().getContextClassLoader().loadClass(propertyType);
            }
            catch (ClassNotFoundException cnfe) {
                if (mustExist) {
                    throw cnfe;
                }
                log.warn((Object)("Unable to find class '" + propertyType + "' for " + "property '" + propertyName + "' - skipping property."));
            }
        }
        Object value = this.getValue(propertyName, expectedPropertyType, propertyValue, mustExist);
        this.handle(new ConfigProperty(propertyName, expectedPropertyType, value), mustExist);
    }

    private String getSetterName(String propertyName) {
        String setter = "set" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 1) {
            setter = setter.concat(propertyName.substring(1));
        }
        return setter;
    }

    private Method getMethod(String setterName, Class expectedPropertyType) throws NoSuchMethodException {
        Method method = null;
        try {
            method = this.configTargetType.getMethod(setterName, expectedPropertyType);
        }
        catch (NoSuchMethodException nsme) {
            expectedPropertyType = PRIMATIVE_TYPE_ALTERNATES.get(expectedPropertyType.getName());
            if (expectedPropertyType == null) {
                throw nsme;
            }
            method = this.configTargetType.getMethod(setterName, expectedPropertyType);
        }
        return method;
    }

    private Object getValue(String propertyName, Class actualType, String value, boolean mustExist) {
        PropertyEditor editor = PropertyEditorManager.findEditor(actualType);
        if (editor == null) {
            String error = "No property editor found for property " + propertyName;
            if (mustExist) {
                throw new IllegalArgumentException(error);
            }
            log.warn((Object)error);
            return null;
        }
        try {
            editor.setAsText(value);
        }
        catch (IllegalArgumentException iae) {
            if (mustExist) {
                throw iae;
            }
            log.warn((Object)("Value '" + value + "' is not valid for property '" + propertyName + "' of class '" + actualType + "' - skipping " + "property"));
            return null;
        }
        return editor.getValue();
    }

    static {
        PRIMATIVE_TYPE_ALTERNATES.put(Boolean.class.getName(), Boolean.TYPE);
        PRIMATIVE_TYPE_ALTERNATES.put(Byte.class.getName(), Byte.TYPE);
        PRIMATIVE_TYPE_ALTERNATES.put(Character.class.getName(), Character.TYPE);
        PRIMATIVE_TYPE_ALTERNATES.put(Double.class.getName(), Double.TYPE);
        PRIMATIVE_TYPE_ALTERNATES.put(Float.class.getName(), Float.TYPE);
        PRIMATIVE_TYPE_ALTERNATES.put(Integer.class.getName(), Integer.TYPE);
        PRIMATIVE_TYPE_ALTERNATES.put(Long.class.getName(), Long.TYPE);
        PRIMATIVE_TYPE_ALTERNATES.put(Short.class.getName(), Short.TYPE);
    }
}

