/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.local;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionManager;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.local.LocalManagedConnectionFactory;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.CachedConnectionManagerReference;
import org.jboss.resource.connectionmanager.ConnectionListenerFactory;
import org.jboss.resource.connectionmanager.InternalManagedConnectionPool;
import org.jboss.resource.connectionmanager.JBossManagedConnectionPool;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.resource.connectionmanager.TxConnectionManager;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;

public class LocalTxDataSource {
    protected static Logger log = Logger.getLogger((String)LocalTxDataSource.class.getName());
    private CachedConnectionManager cachedConnectionManager;
    private TransactionManager transactionManager;
    private String jndiName;
    private InternalManagedConnectionPool.PoolParams poolParams = new InternalManagedConnectionPool.PoolParams();
    private LocalManagedConnectionFactory mcf = new LocalManagedConnectionFactory();
    private JBossManagedConnectionPool.OnePool pool = new JBossManagedConnectionPool.OnePool((ManagedConnectionFactory)this.mcf, this.poolParams, false, log);
    private TxConnectionManager connectionManager;
    private Object datasource;
    protected Hashtable initialContextProperties;
    protected InitialContext initialContext;

    public void setInitialContextProperties(Hashtable initialContextProperties) {
        this.initialContextProperties = initialContextProperties;
    }

    public void start() throws Exception {
        this.initialContext = this.initialContextProperties == null ? new InitialContext() : new InitialContext(this.initialContextProperties);
        this.connectionManager = new TxConnectionManager(this.cachedConnectionManager, (ManagedConnectionPool)this.pool, this.transactionManager);
        this.connectionManager.setLocalTransactions(true);
        this.connectionManager.setInterleaving(false);
        this.pool.setConnectionListenerFactory((ConnectionListenerFactory)this.connectionManager);
        this.datasource = this.connectionManager.getPoolingStrategy().getManagedConnectionFactory().createConnectionFactory((ConnectionManager)new ConnectionManagerDelegate());
        this.bindConnectionFactory();
    }

    protected void bindConnectionFactory() throws Exception {
        InitialContext ctx = this.initialContext;
        try {
            Name name = ctx.getNameParser("").parse(this.jndiName);
            String key = name.toString();
            if (name.size() > 1) {
                int size = name.size() - 1;
                Util.createSubcontext((Context)this.initialContext, (Name)name.getPrefix(size));
            }
            NonSerializableFactory.rebind((Context)this.initialContext, (String)key, (Object)this.datasource);
            log.info((Object)("Bound datasource to JNDI name '" + this.jndiName + "'"));
        }
        catch (NamingException ne) {
            throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.jndiName, (Throwable)ne);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindConnectionFactory() throws Exception {
        InitialContext ctx = this.initialContext;
        try {
            ctx.unbind(this.jndiName);
            NonSerializableFactory.unbind((String)this.jndiName);
            log.info((Object)("Unbound datasource for JNDI name '" + this.jndiName + "'"));
        }
        catch (NamingException ne) {
            log.error((Object)("Could not unbind datasource from jndi: " + this.jndiName), (Throwable)ne);
        }
        finally {
            ctx.close();
        }
    }

    public Object getDatasource() {
        return this.datasource;
    }

    public void setCachedConnectionManager(CachedConnectionManagerReference cachedConnectionManager) {
        this.cachedConnectionManager = cachedConnectionManager.getCachedConnectionManager();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public int getMinSize() {
        return this.poolParams.minSize;
    }

    public void setMinSize(int minSize) {
        this.poolParams.minSize = minSize;
    }

    public int getMaxSize() {
        return this.poolParams.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.poolParams.maxSize = maxSize;
    }

    public int getBlockingTimeout() {
        return this.poolParams.blockingTimeout;
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.poolParams.blockingTimeout = blockingTimeout;
    }

    public long getIdleTimeout() {
        return this.poolParams.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.poolParams.idleTimeout = idleTimeout;
    }

    public String getDriverClass() {
        return this.mcf.getDriverClass();
    }

    public void setDriverClass(String driverClass) {
        this.mcf.setDriverClass(driverClass);
    }

    public String getConnectionURL() {
        return this.mcf.getConnectionURL();
    }

    public void setConnectionURL(String connectionURL) {
        this.mcf.setConnectionURL(connectionURL);
    }

    public void setUserName(String userName) {
        this.mcf.setUserName(userName);
    }

    public void setPassword(String password) {
        this.mcf.setPassword(password);
    }

    public void setPreparedStatementCacheSize(int size) {
        this.mcf.setPreparedStatementCacheSize(size);
    }

    public int getPreparedStatementCacheSize() {
        return this.mcf.getPreparedStatementCacheSize();
    }

    public boolean getSharePreparedStatements() {
        return this.mcf.getSharePreparedStatements();
    }

    public void setSharePreparedStatements(boolean sharePS) {
        this.mcf.setSharePreparedStatements(sharePS);
    }

    public boolean getTxQueryTimeout() {
        return this.mcf.isTransactionQueryTimeout();
    }

    public void setTxQueryTimeout(boolean qt) {
        this.mcf.setTransactionQueryTimeout(qt);
    }

    public String getTransactionIsolation() {
        return this.mcf.getTransactionIsolation();
    }

    public void setTransactionIsolation(String transactionIsolation) {
        this.mcf.setTransactionIsolation(transactionIsolation);
    }

    public String getNewConnectionSQL() {
        return this.mcf.getNewConnectionSQL();
    }

    public void setNewConnectionSQL(String newConnectionSQL) {
        this.mcf.setNewConnectionSQL(newConnectionSQL);
    }

    public String getCheckValidConnectionSQL() {
        return this.mcf.getCheckValidConnectionSQL();
    }

    public void setCheckValidConnectionSQL(String checkValidConnectionSQL) {
        this.mcf.setCheckValidConnectionSQL(checkValidConnectionSQL);
    }

    public String getTrackStatements() {
        return this.mcf.getTrackStatements();
    }

    public void setTrackStatements(String value) {
        this.mcf.setTrackStatements(value);
    }

    public String getExceptionSorterClassName() {
        return this.mcf.getExceptionSorterClassName();
    }

    public void setExceptionSorterClassName(String exceptionSorterClassName) {
        this.mcf.setExceptionSorterClassName(exceptionSorterClassName);
    }

    public String getValidConnectionCheckerClassName() {
        return this.mcf.getValidConnectionCheckerClassName();
    }

    public void setValidConnectionCheckerClassName(String value) {
        this.mcf.setValidConnectionCheckerClassName(value);
    }

    public class ConnectionManagerDelegate
    implements ConnectionManager {
        private static final long serialVersionUID = 1L;

        public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
            return LocalTxDataSource.this.connectionManager.allocateConnection(mcf, cxRequestInfo);
        }
    }
}

