/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import java.net.URLEncoder;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.manager.interfaces.impl.MBeanResource;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNodeMenuEntryImpl;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;

public class EJBModuleLister
extends AbstractPluginWrapper {
    protected static final String JMX_JSR77_DOMAIN = "jboss.management.local";

    ResourceTreeNode[] createBeans(ObjectName parent) throws Exception {
        ObjectInstance[] insts = this.getMBeansForQuery("jboss.management.local:EJBModule=" + parent.getKeyProperty("name") + ",*", null);
        ResourceTreeNode[] ejbs = new ResourceTreeNode[insts.length];
        for (int i = 0; i < insts.length; ++i) {
            ObjectName objName = insts[i].getObjectName();
            String type = objName.getKeyProperty("j2eeType");
            String ejbName = objName.getKeyProperty("name");
            String containerUrl = "jboss.j2ee:service=EJB,jndiName=" + ejbName;
            containerUrl = URLEncoder.encode(containerUrl);
            containerUrl = "/jmx-console/HtmlAdaptor?action=inspectMBean&name=" + containerUrl;
            TreeNodeMenuEntry[] menus = new TreeNodeMenuEntry[]{new SimpleTreeNodeMenuEntryImpl("View container in other window", new HttpLinkTreeAction(containerUrl, "_blank"))};
            String j2eeType = objName.getKeyProperty("j2eeType");
            String filename = "EJB.jsp";
            if (j2eeType.equalsIgnoreCase("StatelessSessionBean")) {
                filename = "StatelessEjb.jsp";
            } else if (j2eeType.equalsIgnoreCase("StatefulSessionBean")) {
                filename = "StatefulEjb.jsp";
            } else if (j2eeType.equalsIgnoreCase("EntityBean")) {
                filename = "EntityEjb.jsp";
            } else if (j2eeType.equalsIgnoreCase("MessageDrivenBean")) {
                filename = "MdbEjb.jsp";
            }
            ejbs[i] = this.createResourceNode(ejbName, type, "images/bean.gif", filename + "?ObjectName=" + this.encode(objName.toString()), menus, null, null, objName.toString(), insts[i].getClassName());
        }
        return ejbs;
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            ObjectName objName = ((MBeanResource)resource).getObjectName();
            return this.createTreeNode(objName.getKeyProperty("name"), "", "images/beans.gif", "EJBModule.jsp?ObjectName=" + this.encode(objName.toString()), null, null, this.createBeans(objName)).setMasterNode(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(this.checker);
            return null;
        }
    }
}

