/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ejb.LocalHome;
import javax.naming.Context;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ejb3.stateless.StatelessLocalProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessLocalProxyFactory
extends BaseStatelessProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessLocalProxyFactory.class);

    protected Class<?>[] getInterfaces() {
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        boolean bindTogether = false;
        if (localHome != null && this.bindHomeAndBusinessTogether(statelessContainer)) {
            bindTogether = true;
        }
        ArrayList<Class> localInterfaces = new ArrayList<Class>();
        localInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getLocalInterfaces((Container)statelessContainer)));
        if (localInterfaces.size() > 0) {
            localInterfaces.add(JBossProxy.class);
            if (bindTogether) {
                localInterfaces.add(localHome.value());
            }
        } else {
            log.warn((Object)"[EJBTHREE-933] NPE when deploying web service beans");
        }
        return localInterfaces.toArray(new Class[0]);
    }

    protected boolean bindHomeAndBusinessTogether(EJBContainer container) {
        return ProxyFactoryHelper.getLocalHomeJndiName((Container)container).equals(ProxyFactoryHelper.getLocalJndiName((Container)container));
    }

    @Override
    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getLocalJndiName((Container)this.getContainer());
    }

    @Override
    public void start() throws Exception {
        super.start();
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            StatelessLocalProxy proxy = new StatelessLocalProxy(this.getContainer());
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), interfaces, (InvocationHandler)proxy);
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName((Container)this.getContainer()), (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName((Container)this.getContainer()));
        }
    }

    @Override
    public Object createProxy() {
        return this.constructProxy(new StatelessLocalProxy(this.getContainer()));
    }

    @Override
    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        LocalBinding localBinding = (LocalBinding)((Advisor)this.getContainer()).resolveAnnotation(LocalBinding.class);
        if (localBinding != null) {
            handle.jndiName = localBinding.jndiBinding();
        }
        return handle;
    }
}

