/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.encryption;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.encryption.EncryptionManager;
import org.jboss.remoting.marshal.encryption.EncryptionOutputStream;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class EncryptingMarshaller
extends SerializableMarshaller {
    private static final long serialVersionUID = 1L;
    public static final String DATATYPE = "encrypt";
    private Marshaller wrappedMarshaller;
    private String cipherAlgorithm = "DES";
    private Cipher cipher = EncryptionManager.getCipher(1, this.cipherAlgorithm);

    public EncryptingMarshaller() {
    }

    public EncryptingMarshaller(String algo, Key key) {
        this.cipher = EncryptionManager.getCipher(1, algo, key);
    }

    public EncryptingMarshaller(Marshaller marshaller) {
        this.wrappedMarshaller = marshaller;
    }

    public void setCipherAlgorithm(String algo) {
        this.cipherAlgorithm = algo;
        this.cipher = EncryptionManager.getCipher(1, this.cipherAlgorithm);
    }

    public void write(Object dataObject, OutputStream output, int version) throws IOException {
        if (this.cipher == null) {
            throw new IllegalStateException("Cipher is null for algo=" + this.cipherAlgorithm);
        }
        output.flush();
        EncryptionOutputStream eos = new EncryptionOutputStream(output);
        CipherOutputStream cos = new CipherOutputStream(eos, this.cipher);
        SerializationManager sm = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
        ObjectOutputStream oos = sm.createOutput(cos);
        if (this.wrappedMarshaller != null) {
            if (this.wrappedMarshaller instanceof VersionedMarshaller) {
                ((VersionedMarshaller)this.wrappedMarshaller).write(dataObject, oos, version);
            } else {
                this.wrappedMarshaller.write(dataObject, oos);
            }
        } else {
            super.write(dataObject, oos, version);
        }
        oos.flush();
        cos.close();
        oos.close();
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        EncryptingMarshaller em = new EncryptingMarshaller(this.wrappedMarshaller);
        em.setCipherAlgorithm(this.cipherAlgorithm);
        return em;
    }
}

