/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.ejb3.EJBContainer;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.InjectionTarget;
import org.jboss.metamodel.descriptor.Ref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionUtil {
    private static final Logger log = Logger.getLogger(InjectionUtil.class);

    public static void collapseXmlMethodInjectors(Set<String> visitedMethods, Class clazz, Map<String, Map<AccessibleObject, Injector>> xmlDefinedInjectors, Map<AccessibleObject, Injector> classInjectors) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Map<AccessibleObject, Injector> xmlInjectors = xmlDefinedInjectors.get(clazz.getName());
        if (xmlInjectors != null) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 1 || Modifier.isPrivate(method.getModifiers())) continue;
                if (visitedMethods.contains(method.getName())) {
                    xmlInjectors.remove(method);
                    continue;
                }
                visitedMethods.add(method.getName());
            }
            classInjectors.putAll(xmlInjectors);
        }
        InjectionUtil.collapseXmlMethodInjectors(visitedMethods, clazz.getSuperclass(), xmlDefinedInjectors, classInjectors);
    }

    public static void processMethodAnnotations(InjectionContainer container, Collection<InjectionHandler> handlers, Set<String> visitedMethods, Class clazz, Map<AccessibleObject, Injector> classInjectors) {
        Method[] methods;
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1) continue;
            if (!Modifier.isPrivate(method.getModifiers())) {
                if (visitedMethods.contains(method.getName())) continue;
                visitedMethods.add(method.getName());
            }
            if (handlers == null) continue;
            for (InjectionHandler handler : handlers) {
                handler.handleMethodAnnotations(method, container, classInjectors);
            }
        }
        InjectionUtil.processMethodAnnotations(container, handlers, visitedMethods, clazz.getSuperclass(), classInjectors);
    }

    public static void processFieldAnnotations(InjectionContainer container, Collection<InjectionHandler> handlers, Class clazz, Map<AccessibleObject, Injector> classInjectors) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        if (handlers != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                log.trace("process field annotation for " + field.toGenericString());
                for (InjectionHandler handler : handlers) {
                    handler.handleFieldAnnotations(field, container, classInjectors);
                }
            }
        }
        InjectionUtil.processFieldAnnotations(container, handlers, clazz.getSuperclass(), classInjectors);
    }

    public static void processClassAnnotations(InjectionContainer container, Collection<InjectionHandler> handlers, Class clazz) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        if (handlers != null) {
            for (InjectionHandler handler : handlers) {
                handler.handleClassAnnotations(clazz, container);
            }
        }
        InjectionUtil.processClassAnnotations(container, handlers, clazz.getSuperclass());
    }

    public static Map<AccessibleObject, Injector> processAnnotations(InjectionContainer container, Collection<InjectionHandler> handlers, Class clazz) {
        HashMap<AccessibleObject, Injector> classInjectors = new HashMap<AccessibleObject, Injector>();
        HashSet<String> visitedMethods = new HashSet<String>();
        InjectionUtil.collapseXmlMethodInjectors(visitedMethods, clazz, container.getEncInjections(), classInjectors);
        InjectionUtil.processClassAnnotations(container, handlers, clazz);
        visitedMethods = new HashSet();
        InjectionUtil.processMethodAnnotations(container, handlers, visitedMethods, clazz, classInjectors);
        InjectionUtil.processFieldAnnotations(container, handlers, clazz, classInjectors);
        return classInjectors;
    }

    public static AccessibleObject findInjectionTarget(ClassLoader loader, InjectionTarget target) {
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(target.getTargetClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("<injection-target> class: " + target.getTargetClass() + " was not found nin deployment");
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!target.getTargetName().equals(field.getName())) continue;
            return field;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!((Method)accessibleObject).getName().equals(target.getTargetName())) continue;
            return accessibleObject;
        }
        throw new RuntimeException("<injection-target> could not be found: " + target.getTargetClass() + "." + target.getTargetName());
    }

    public static String getEncName(Class type) {
        return "env/" + type.getName();
    }

    public static String getEncName(Method method) {
        String encName = method.getName().substring(3);
        encName = encName.length() > 1 ? encName.substring(0, 1).toLowerCase() + encName.substring(1) : encName.toLowerCase();
        encName = InjectionUtil.getEncName(method.getDeclaringClass()) + "/" + encName;
        return encName;
    }

    public static String getEncName(Field field) {
        return InjectionUtil.getEncName(field.getDeclaringClass()) + "/" + field.getName();
    }

    public static Object getAnnotation(Class annotation, EJBContainer container, Class annotatedClass, boolean isContainer) {
        if (isContainer) {
            return container.resolveAnnotation(annotation);
        }
        return annotatedClass.getAnnotation(annotation);
    }

    public static Object getAnnotation(Class annotation, EJBContainer container, Method method, boolean isContainer) {
        if (isContainer) {
            return container.resolveAnnotation(method, annotation);
        }
        return method.getAnnotation(annotation);
    }

    public static Object getAnnotation(Class annotation, EJBContainer container, Field field, boolean isContainer) {
        if (isContainer) {
            return container.resolveAnnotation(field, annotation);
        }
        return field.getAnnotation(annotation);
    }

    public static Class injectionTarget(String encName, Ref ref, InjectionContainer container, Map<String, Map<AccessibleObject, Injector>> classInjectors) {
        if (ref.getInjectionTarget() != null) {
            Class<?> injectionType;
            AccessibleObject ao = InjectionUtil.findInjectionTarget(container.getClassloader(), ref.getInjectionTarget());
            Map<AccessibleObject, Injector> injectors = classInjectors.get(ref.getInjectionTarget().getTargetClass());
            if (injectors == null) {
                injectors = new HashMap<AccessibleObject, Injector>();
                classInjectors.put(ref.getInjectionTarget().getTargetClass().trim(), injectors);
            }
            if (ao instanceof Field) {
                injectionType = ((Field)ao).getType();
                injectors.put(ao, new JndiFieldInjector((Field)ao, encName, container.getEnc()));
            } else {
                injectionType = ((Method)ao).getParameterTypes()[0];
                injectors.put(ao, new JndiMethodInjector((Method)ao, encName, container.getEnc()));
            }
            return injectionType;
        }
        return null;
    }
}

