/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.naming.NamingServiceMBean;
import org.jboss.system.server.ServerConfigUtil;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.mux.MuxChannel;
import org.jgroups.stack.IpAddress;

public class JChannelFactory
extends org.jgroups.jmx.JChannelFactory {
    protected static Logger log = Logger.getLogger(JChannelFactory.class);
    private InetAddress nodeAddress;
    private String nodeName;

    public Channel createMultiplexerChannel(String stack_name, String id, boolean register_for_state_transfer, String substate_id) throws Exception {
        Channel channel = super.createMultiplexerChannel(stack_name, id, register_for_state_transfer, substate_id);
        this.setChannelUniqueId(channel);
        return channel;
    }

    public Channel createMultiplexerChannel(String stack_name, String id) throws Exception {
        Channel channel = super.createMultiplexerChannel(stack_name, id);
        this.setChannelUniqueId(channel);
        return channel;
    }

    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(InetAddress nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    private void setChannelUniqueId(Channel channel) throws Exception {
        IpAddress address = (IpAddress)channel.getLocalAddress();
        if (address == null) {
            if (this.nodeName == null || "".equals(this.nodeName)) {
                this.nodeName = this.generateUniqueNodeName();
            }
            log.debug((Object)("Passing unique node id " + this.nodeName + " to the channel as additional data"));
            HashMap<String, byte[]> staticNodeName = new HashMap<String, byte[]>();
            staticNodeName.put("additional_data", this.nodeName.getBytes());
            channel.down(new Event(56, staticNodeName));
        } else if (address.getAdditionalData() == null) {
            Channel testee = channel;
            if (channel instanceof MuxChannel) {
                testee = ((MuxChannel)channel).getChannel();
            }
            if (testee.isConnected()) {
                throw new IllegalStateException("Underlying JChannel was connected before additional_data was set");
            }
        } else if (this.nodeName == null || "".equals(this.nodeName)) {
            this.nodeName = new String(address.getAdditionalData());
            log.warn((Object)("Field nodeName was not set but mux channel already had additional data -- setting nodeName to " + this.nodeName));
        }
    }

    private String generateUniqueNodeName() throws Exception {
        String hostIP = null;
        InetAddress address = ServerConfigUtil.fixRemoteAddress((InetAddress)this.nodeAddress);
        if (address == null) {
            log.debug((Object)"unable to create a GUID for this cluster, check network configuration is correctly setup (getLocalHost has returned an exception)");
            log.debug((Object)"using a full GUID strategy");
            return new VMID().toString();
        }
        hostIP = address.getHostAddress();
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            AttributeList al = server.getAttributes(NamingServiceMBean.OBJECT_NAME, new String[]{"State", "Port"});
            int status = (Integer)((Attribute)al.get(0)).getValue();
            if (status == 3) {
                int port = (Integer)((Attribute)al.get(1)).getValue();
                return hostIP + ":" + port;
            }
            log.debug((Object)"JNDI has been found but the service wasn't started so we cannot be entirely sure we are the only one that wants to use this PORT as a GUID on this host.");
        }
        catch (InstanceNotFoundException e) {
            log.debug((Object)"JNDI not running here, cannot use this strategy to find a node GUID for the cluster");
        }
        catch (ReflectionException e) {
            log.debug((Object)"JNDI querying has returned an exception, cannot use this strategy to find a node GUID for the cluster");
        }
        String uid = new UID().toString();
        return hostIP + ":" + uid;
    }
}

