package org.jboss.as.naming.javaee;

import org.jboss.as.javaee.SimpleJavaEEModuleIdentifier;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer;

/**
 * @author <a href="cdewolf@redhat.com">Carlo de Wolf</a>
 */
public class NamingJavaEEModuleInformer extends NamingJavaEEApplicationInformer implements JavaEEModuleInformer
{
   // TODO: for now we delegate to the former JPA SPI informer. This informer should be merged with that one into one integration component
   private SimpleJavaEEModuleIdentifier identifier;

   public String getApplicationName(DeploymentUnit deploymentUnit)
   {
      return super.getApplicationName(deploymentUnit.getTopLevel());
   }

   public String getModulePath(DeploymentUnit deploymentUnit)
   {
      /*
       * JavaEE 6 FR 8.1.1:
       * The name can be explicitly set in the deployment descriptor for the module. If not set, the name
       * of the module is the pathname of the module in the ear file with any filename extension (.jar, .war, .rar)
       * removed, but with any directory names included.
       */
      // TODO: get the module name from the deployment descriptor
      // FIXME: AS can't handle unique module names yet because we deploy a.jar and a.war at the same time, to counter don't strip the extension.
      String path = deploymentUnit.getRelativePath();
      if(path == null || path.length() == 0)
         path = deploymentUnit.getSimpleName();
      return path;
   }

   public ModuleType getModuleType(DeploymentUnit deploymentUnit)
   {
      return identifier.getModuleType(deploymentUnit);
   }

   public void setJavaEEModuleIdentifier(SimpleJavaEEModuleIdentifier identifier)
   {
      this.identifier = identifier;
   }
}
