/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.test.server.profileservice.support;

import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;

import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.api.config.ServerConfig;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.api.server.Server;
import org.jboss.bootstrap.spi.server.ServerInitializer;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 97916 $
 */
public class MockServer implements Server
{

   public ServerConfig config;
   
   public MockServer(ServerConfig config)
   {
      this.config = config;
   }
   
   public ServerConfig getConfig() throws IllegalStateException
   {
      return this.config;
   }
   
   public String getBuildDate()
   {
      // FIXME getBuildDate
      return null;
   }

   public String getBuildID()
   {
      // FIXME getBuildID
      return null;
   }

   public String getBuildJVM()
   {
      // FIXME getBuildJVM
      return null;
   }

   public String getBuildNumber()
   {
      // FIXME getBuildNumber
      return null;
   }

   public String getBuildOS()
   {
      // FIXME getBuildOS
      return null;
   }

   public Date getStartDate()
   {
      // FIXME getStartDate
      return null;
   }

   public String getVersion()
   {
      // FIXME getVersion
      return null;
   }

   public String getVersionName()
   {
      // FIXME getVersionName
      return null;
   }

   public String getVersionNumber()
   {
      // FIXME getVersionNumber
      return null;
   }

   public void init(Properties props) throws IllegalStateException, Exception
   {
      init(props, null);
   }
   public void init(Properties props, Map<String, Object> metadata) throws IllegalStateException, Exception
   {
      // FIXME init
      
   }
   public Map<String, Object> getMetaData()
   {
      return Collections.emptyMap();
   }
   public boolean isInShutdown()
   {
      // FIXME isInShutdown
      return false;
   }

   public boolean isStarted()
   {
      // FIXME isStarted
      return false;
   }

   public void shutdown() throws IllegalStateException
   {
      // FIXME shutdown
      
   }

   public void start() throws IllegalStateException, Exception
   {
      // FIXME start
      
   }

   public void stop() throws IllegalStateException, Exception
   {
      // FIXME stop
      
   }

   public void addBootstrap(Bootstrap bootstrap) throws IllegalArgumentException
   {
      // FIXME addBootstrap
      
   }

   public ConfigurationInitializer getConfigInitializer()
   {
      // FIXME getConfigInitializer
      return null;
   }

   public ServerConfig getConfiguration()
   {
      // FIXME getConfiguration
      return null;
   }

   public ServerInitializer getServerInitializer()
   {
      // FIXME getServerInitializer
      return null;
   }

   public LifecycleState getState()
   {
      // FIXME getState
      return null;
   }

   public ConfigurationValidator getValidator()
   {
      // FIXME getValidator
      return null;
   }

   public void initialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException
   {
      // FIXME initialize
      
   }

   public void registerEventHandler(LifecycleState state, LifecycleEventHandler handler)
         throws IllegalArgumentException
   {
      // FIXME registerEventHandler
      
   }

   public void registerEventHandler(LifecycleEventHandler handler, EnumSet states) throws IllegalArgumentException
   {
      // FIXME registerEventHandler
      
   }

   public void registerEventHandler(LifecycleEventHandler handler, LifecycleState... states)
         throws IllegalArgumentException
   {
      // FIXME registerEventHandler
      
   }

   public void registerEventHandlers(LifecycleState state, LifecycleEventHandler... handlers)
         throws IllegalArgumentException
   {
      // FIXME registerEventHandlers
      
   }

   public void removeBootstrap(Bootstrap bootstrap) throws IllegalArgumentException
   {
      // FIXME removeBootstrap
      
   }

   public void setConfigInitializer(ConfigurationInitializer configInitializer) throws IllegalStateException
   {
      // FIXME setConfigInitializer
      
   }

   public void setConfiguration(ServerConfig config)
   {
      // FIXME setConfiguration
      
   }

   public void setServerInitializer(ServerInitializer serverInitializer) throws IllegalStateException
   {
      // FIXME setServerInitializer
      
   }

   public void setValidator(ConfigurationValidator validator) throws IllegalStateException
   {
      // FIXME setValidator
      
   }

   public boolean unregisterEventHandler(LifecycleEventHandler handler, LifecycleState state)
         throws IllegalArgumentException
   {
      // FIXME unregisterEventHandler
      return false;
   }

}

