/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.remoting;

import java.io.InputStream;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.deployment.services.DeploymentManagerServiceMBean;
import org.jboss.deployment.spi.SerializableTargetModuleID;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;

public class DeployHandler
implements StreamInvocationHandler {
    static Logger log = Logger.getLogger(DeployHandler.class);
    private DeploymentManagerServiceMBean deployService;

    public DeploymentManagerServiceMBean getDeployService() {
        return this.deployService;
    }

    public void setDeployService(DeploymentManagerServiceMBean deployService) {
        this.deployService = deployService;
    }

    public Object handleStream(InputStream contentIS, InvocationRequest request) throws Throwable {
        SerializableTargetModuleID moduleID = (SerializableTargetModuleID)request.getParameter();
        log.debug((Object)("handleStream, moduleID: " + moduleID));
        moduleID.setContentIS(contentIS);
        this.deployService.deploy(moduleID);
        return null;
    }

    public void addListener(InvokerCallbackHandler arg0) {
    }

    public Object invoke(InvocationRequest request) throws Throwable {
        String name = request.getParameter().toString();
        Map payload = request.getRequestPayload();
        String url = (String)payload.get("moduleID");
        SerializableTargetModuleID[] returnValue = null;
        log.debug((Object)("invoke, moduleID: " + url + ", payload: " + payload));
        if (name.equals("start")) {
            this.deployService.start(url);
        } else if (name.equals("stop")) {
            this.deployService.stop(url);
        } else if (name.equals("undeploy")) {
            this.deployService.undeploy(url);
        } else if (name.equals("getAvailableModules")) {
            SerializableTargetModuleID[] ids;
            Integer moduleType = (Integer)payload.get("moduleType");
            returnValue = ids = this.deployService.getAvailableModules(moduleType);
        }
        return returnValue;
    }

    public void removeListener(InvokerCallbackHandler arg0) {
    }

    public void setInvoker(ServerInvoker arg0) {
    }

    public void setMBeanServer(MBeanServer server) {
        try {
            ObjectName jsr88 = new ObjectName("jboss.management.local:type=JSR88DeploymentManager,name=DefaultManager");
            this.deployService = MBeanServerInvocationHandler.newProxyInstance(server, jsr88, DeploymentManagerServiceMBean.class, false);
            log.debug((Object)"Initialzied DeploymentManagerServiceMBean");
        }
        catch (Exception e) {
            log.warn((Object)"Failed to lookup DeploymentManagerServiceMBean", (Throwable)e);
        }
    }
}

