/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.ejb;

import java.io.Serializable;
import java.lang.reflect.Field;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContextImpl;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.stateful.StatefulSessionContextImpl;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.api.WeldManager;

public class SessionBeanInterceptor
implements Serializable {
    private static final long serialVersionUID = 7327757031821596782L;
    private static final Field statefulGuidField;
    private static final Field beanContextField;
    @Resource
    private SessionContext sessionContext;
    @Resource(mappedName="java:app/BeanManager")
    private WeldManager beanManager;
    private CreationalContext<Object> creationalContext;
    private InjectionTarget<Object> injectionTarget;
    public static final String CREATIONAL_CONTEXT = "org.jboss.weld.integration.ejb.SessionBeanInterceptor.creationalContext";
    public static final String EJB_DESCRIPTOR = "org.jboss.weld.integration.ejb.SessionBeanInterceptor.ejbName";

    @PostConstruct
    public void postConstruct(InvocationContext invocationContext) throws Exception {
        String ejbName = this.getEjbName();
        EjbDescriptor descriptor = this.beanManager.getEjbDescriptor(ejbName);
        this.injectionTarget = this.beanManager.createInjectionTarget(descriptor);
        Bean bean = this.beanManager.getBean(descriptor);
        this.creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        this.injectionTarget.inject(invocationContext.getTarget(), this.creationalContext);
        invocationContext.getContextData().put(CREATIONAL_CONTEXT, this.creationalContext);
        invocationContext.getContextData().put(EJB_DESCRIPTOR, descriptor);
        invocationContext.proceed();
    }

    @PreDestroy
    public void preDestroy(InvocationContext invocationContext) throws Exception {
        this.creationalContext.release();
        invocationContext.proceed();
    }

    private String getEjbName() {
        if (this.sessionContext instanceof StatefulSessionContextImpl) {
            try {
                String guid = (String)statefulGuidField.get(this.sessionContext);
                Container container = Ejb3Registry.getContainer((String)guid);
                return container.getEjbName();
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.sessionContext instanceof EJBContextImpl) {
            try {
                BeanContext beanContext = (BeanContext)beanContextField.get(this.sessionContext);
                return beanContext.getContainer().getEjbName();
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Unable to extract ejb name from SessionContext " + this.sessionContext);
    }

    static {
        try {
            statefulGuidField = StatefulSessionContextImpl.class.getDeclaredField("containerGuid");
            statefulGuidField.setAccessible(true);
            beanContextField = EJBContextImpl.class.getDeclaredField("beanContext");
            beanContextField.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

