/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.BindingType;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.core.jaxws.spi.EndpointImpl;
import org.jboss.ws.core.jaxws.spi.ServiceDelegateImpl;
import org.jboss.ws.core.jaxws.wsaddressing.EndpointReferenceUtil;
import org.jboss.ws.core.jaxws.wsaddressing.NativeEndpointReference;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;

public final class ProviderImpl
extends Provider {
    public Endpoint createAndPublishEndpoint(String address, Object implementor) {
        return this.createAndPublishEndpoint(address, implementor, null);
    }

    public Endpoint createAndPublishEndpoint(String address, Object implementor, WebServiceFeature ... features) {
        String bindingId = this.getBindingFromAddress(address);
        EndpointImpl endpoint = (EndpointImpl)this.createEndpoint(bindingId, implementor, features);
        endpoint.publish(address);
        return endpoint;
    }

    public Endpoint createEndpoint(String bindingId, Object implementor) {
        return this.createEndpoint(bindingId, implementor, null);
    }

    public Endpoint createEndpoint(String bindingId, Object implementor, WebServiceFeature ... features) {
        String nonNullBindingId = this.getBindingId(bindingId, implementor.getClass());
        return new EndpointImpl(nonNullBindingId, implementor, features);
    }

    public ServiceDelegate createServiceDelegate(URL wsdlLocation, QName serviceName, Class serviceClass) {
        return this.createServiceDelegate(wsdlLocation, serviceName, serviceClass, null);
    }

    public ServiceDelegate createServiceDelegate(URL wsdlLocation, QName serviceName, Class serviceClass, WebServiceFeature ... features) {
        try {
            ServiceDelegateImpl delegate = new ServiceDelegateImpl(wsdlLocation, serviceName, serviceClass, features);
            DOMUtils.clearThreadLocals();
            return delegate;
        }
        catch (RuntimeException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public W3CEndpointReference createW3CEndpointReference(String address, QName interfaceName, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters, List<Element> elements, Map<QName, String> attributes) {
        throw new UnsupportedOperationException();
    }

    public W3CEndpointReference createW3CEndpointReference(String address, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters) {
        NativeEndpointReference epr = new NativeEndpointReference();
        epr.setAddress(address);
        epr.setServiceName(serviceName);
        epr.setEndpointName(portName);
        epr.setMetadata(metadata);
        epr.setWsdlLocation(wsdlDocumentLocation);
        epr.setReferenceParameters(referenceParameters);
        return EndpointReferenceUtil.transform(W3CEndpointReference.class, epr);
    }

    public <T> T getPort(EndpointReference epr, Class<T> sei, WebServiceFeature ... features) {
        NativeEndpointReference nepr = EndpointReferenceUtil.transform(NativeEndpointReference.class, epr);
        URL wsdlLocation = nepr.getWsdlLocation();
        QName serviceName = nepr.getServiceName();
        ServiceDelegate delegate = this.createServiceDelegate(wsdlLocation, serviceName, Service.class);
        return (T)delegate.getPort(epr, sei, features);
    }

    public EndpointReference readEndpointReference(Source eprInfoset) {
        if (eprInfoset == null) {
            throw new NullPointerException("Provided eprInfoset cannot be null");
        }
        try {
            return new W3CEndpointReference(eprInfoset);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private String getBindingFromAddress(String address) {
        try {
            URL url = new URL(address);
            String protocol = url.getProtocol();
            if (protocol.toLowerCase().startsWith("http")) {
                return "http://schemas.xmlsoap.org/wsdl/soap/http";
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid endpoint address: " + address);
        }
        throw new IllegalArgumentException("Unsupported protocol: " + address);
    }

    private String getBindingId(String bindingId, Class<?> implementorClass) {
        if (bindingId != null) {
            return bindingId;
        }
        BindingType bindingType = implementorClass.getAnnotation(BindingType.class);
        return bindingType != null ? bindingType.value() : "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

