/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.ws.core.server.MimeHeaderSource;

public abstract class AbstractNettyMessage
extends DefaultHttpMessage
implements MimeHeaderSource,
HttpResponse {
    private HttpResponseStatus status;
    private HttpRequest request;
    private Channel channel;

    protected AbstractNettyMessage(HttpVersion version, Channel channel, HttpRequest request) {
        super(version);
        this.channel = channel;
        this.request = request;
    }

    public abstract InputStream getInputStream();

    public abstract OutputStream getOutputStream();

    protected final HttpRequest getRequest() {
        return this.request;
    }

    protected final Channel getChannel() {
        return this.channel;
    }

    public final HttpResponseStatus getStatus() {
        return this.status;
    }

    public final void setStatus(int sc) {
        this.status = HttpResponseStatus.valueOf((int)sc);
    }

    public final void setCookies() {
        CookieDecoder cookieDecoder;
        Set cookies;
        String cookieString = this.getRequest().getHeader("Cookie");
        if (cookieString != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            this.addHeader("Set-Cookie", cookieEncoder.encode());
        }
    }

    public final String toString() {
        return this.getProtocolVersion().getText() + ' ' + this.getStatus();
    }

    @Override
    public final MimeHeaders getMimeHeaders() {
        if (this.request.getHeaderNames().size() == 0) {
            return null;
        }
        MimeHeaders headers = new MimeHeaders();
        Iterator e = this.request.getHeaderNames().iterator();
        String key = null;
        String value = null;
        while (e.hasNext()) {
            key = (String)e.next();
            value = this.request.getHeader(key);
            headers.addHeader(key, value);
        }
        return headers;
    }

    @Override
    public final void setMimeHeaders(MimeHeaders headers) {
        Iterator i = headers.getAllHeaders();
        String key = null;
        while (i.hasNext()) {
            MimeHeader header = (MimeHeader)i.next();
            key = header.getName();
            List<String> values = new LinkedList<String>();
            values.add(header.getValue());
            values = this.removeProhibitedCharacters(values);
            this.setHeader(key, values);
        }
    }

    private List<String> removeProhibitedCharacters(List<String> values) {
        LinkedList<String> retVal = new LinkedList<String>();
        for (int i = 0; i < values.size(); ++i) {
            retVal.add(i, this.removeProhibitedCharacters(values.get(i)));
        }
        return retVal;
    }

    private String removeProhibitedCharacters(String value) {
        String retVal = value;
        retVal = retVal.replace('\r', ' ');
        retVal = retVal.replace('\n', ' ');
        return retVal;
    }
}

