/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

public abstract class AbstractJMSTransportSupport
implements MessageListener {
    protected Logger log = Logger.getLogger(AbstractJMSTransportSupport.class);
    private QueueConnectionFactory conFactory;

    public void onMessage(Message message) {
        try {
            String msgStr = null;
            if (message instanceof BytesMessage) {
                msgStr = this.getMessageStr((BytesMessage)message);
            } else if (message instanceof TextMessage) {
                msgStr = ((TextMessage)message).getText();
            } else {
                this.log.warn((Object)("Invalid message type: " + message));
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Incomming SOAP message: " + msgStr));
            }
            String fromName = null;
            Destination destination = message.getJMSDestination();
            if (destination instanceof Queue) {
                fromName = "queue/" + ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                fromName = "topic/" + ((Topic)destination).getTopicName();
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(msgStr.getBytes());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
            this.processSOAPMessage(fromName, inputStream, outputStream);
            msgStr = new String(outputStream.toByteArray());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Outgoing SOAP message: " + msgStr));
            }
            if (msgStr.length() > 0) {
                Queue replyQueue = this.getReplyQueue(message);
                if (replyQueue != null) {
                    this.sendResponse(replyQueue, msgStr);
                } else {
                    this.log.warn((Object)"No reply queue, ignore response message");
                }
            } else {
                this.log.debug((Object)"SOAP response message is null");
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSOAPMessage(String fromName, InputStream inputStream, OutputStream outStream) throws SOAPException, IOException, RemoteException {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        EndpointRegistry epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        Endpoint endpoint = this.getEndpointForDestination(epRegistry, fromName);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find endpoint for: " + fromName);
        }
        EndpointAssociation.setEndpoint((Endpoint)endpoint);
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug((Object)("dipatchMessage: " + endpoint.getName()));
            }
            Endpoint.EndpointState state = endpoint.getState();
            ObjectName name = endpoint.getName();
            long startTime = System.currentTimeMillis();
            if (debugEnabled) {
                this.log.debug((Object)(name + " is in state: " + state));
            }
            while (state != Endpoint.EndpointState.STARTED && System.currentTimeMillis() - startTime < 60000L) {
                try {
                    Thread.sleep(1000L);
                    state = endpoint.getState();
                    if (!debugEnabled) continue;
                    this.log.debug((Object)(name + " is now in state: " + state));
                }
                catch (InterruptedException e) {
                    throw new EJBException((Exception)e);
                }
            }
            RequestHandler reqHandler = endpoint.getRequestHandler();
            try {
                InvocationContext invContext = new InvocationContext();
                invContext.setTargetBean((Object)this);
                reqHandler.handleRequest(endpoint, inputStream, outStream, invContext);
            }
            catch (Exception ex) {
                throw new RemoteException("Cannot process SOAP request", ex);
            }
        }
        finally {
            EndpointAssociation.removeEndpoint();
        }
    }

    private Endpoint getEndpointForDestination(EndpointRegistry epRegistry, String fromName) {
        Endpoint endpoint = null;
        for (ObjectName oname : epRegistry.getEndpoints()) {
            Endpoint aux = epRegistry.getEndpoint(oname);
            String jmsProp = aux.getName().getKeyProperty("jms");
            if (jmsProp == null || !jmsProp.equals(fromName)) continue;
            endpoint = aux;
            break;
        }
        return endpoint;
    }

    private String getMessageStr(BytesMessage message) throws Exception {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
        int read = message.readBytes(buffer);
        while (read != -1) {
            out.write(buffer, 0, read);
            read = message.readBytes(buffer);
        }
        byte[] msgBytes = out.toByteArray();
        return new String(msgBytes);
    }

    protected Queue getReplyQueue(Message message) throws JMSException {
        Queue replyQueue = (Queue)message.getJMSReplyTo();
        return replyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Queue replyQueue, String msgStr) throws SOAPException, IOException, JMSException {
        QueueConnection qc = this.getQueueFactory().createQueueConnection();
        QueueSession session = qc.createQueueSession(false, 1);
        QueueSender sender = null;
        try {
            sender = session.createSender(replyQueue);
            TextMessage responseMessage = session.createTextMessage(msgStr);
            sender.send((Message)responseMessage);
            this.log.info((Object)"Sent response");
        }
        finally {
            try {
                sender.close();
            }
            catch (JMSException ignored) {}
            try {
                session.close();
            }
            catch (JMSException ignored) {}
            try {
                qc.close();
            }
            catch (JMSException ignored) {}
        }
    }

    private QueueConnectionFactory getQueueFactory() {
        if (this.conFactory == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.conFactory = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.conFactory;
    }
}

